/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.systemsettings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

@ApiModel(description="Email server configuration settings.")
public class EmailServerSettings {
    public static final int INFINITE_TIMEOUT = -1;
    private String sourceAddr;
    private String emailServer;
    private int port = NumberUtils.toInt((String)"25");
    private int sslPort = NumberUtils.toInt((String)"465");
    private int timeout = NumberUtils.toInt((String)"30");
    private boolean useSSL;
    private boolean useTLS;
    private boolean verifyHostname;
    private boolean enableUtf8MsgHeaders = false;
    private boolean useDebugging;
    private String username;
    private String password;
    private String encryptedPassword;
    private int retryAttempts = NumberUtils.toInt((String)"2");
    private int retryDelay = NumberUtils.toInt((String)"2");

    @ApiModelProperty(position=10, value="The email address that appears in the 'From' header line in email messages generated by PingFederate.  The address must be in valid format but need not be set up on your system.", required=true)
    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    @ApiModelProperty(position=20, value="The IP address or hostname of your email server.", required=true)
    public String getEmailServer() {
        return this.emailServer;
    }

    public void setEmailServer(String emailServer) {
        this.emailServer = emailServer;
    }

    @ApiModelProperty(position=30, value="The SMTP port on your email server. Allowable values: 1 - 65535. The default value is 25.", required=true)
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ApiModelProperty(position=40, value="The secure SMTP port on your email server. This field is not active unless Use SSL is enabled. Allowable values: 1 - 65535. The default value is  465.")
    public int getSslPort() {
        return this.sslPort;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    @ApiModelProperty(position=50, value="The amount of time in seconds that PingFederate will wait before it times out connecting to the SMTP server. Allowable values: 0 - 3600. The default value is 30.")
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @ApiModelProperty(position=55, value="The number of times PingFederate tries to resend an email upon unsuccessful delivery. The default value is 2.")
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    @ApiModelProperty(position=56, value="The number of minutes PingFederate waits before the next retry attempt. The default value is 2.")
    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    @ApiModelProperty(position=60, value="Requires the use of SSL/TLS on the port specified by 'sslPort'. If this option is enabled, it overrides the 'useTLS' option.")
    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @ApiModelProperty(position=70, value="Requires the use of the STARTTLS protocol on the port specified by 'port'.")
    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    @ApiModelProperty(position=75, value="If useSSL or useTLS is enabled, this flag determines whether the email server hostname is verified against the server's SMTPS certificate.")
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    @ApiModelProperty(position=80, value="Only set this flag to true if the email server supports UTF-8 characters in message headers. Otherwise, this is defaulted to false.")
    public boolean isEnableUtf8MessageHeaders() {
        return this.enableUtf8MsgHeaders;
    }

    public void setEnableUtf8MessageHeaders(boolean allowUtf8MsgHeaders) {
        this.enableUtf8MsgHeaders = allowUtf8MsgHeaders;
    }

    @ApiModelProperty(position=85, value="Turns on detailed error messages for the PingFederate server log to help troubleshoot any problems.")
    public boolean isUseDebugging() {
        return this.useDebugging;
    }

    public void setUseDebugging(boolean useDebugging) {
        this.useDebugging = useDebugging;
    }

    @ApiModelProperty(position=90, value="Authorized email username. Required if the password is provided.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ApiModelProperty(position=100, value="User password.  To update the password, specify the plaintext value in this field.  This field will not be populated for GET requests.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(position=110, value="For GET requests, this field contains the encrypted password, if one exists.  For POST and PUT requests, if you wish to reuse the existing password, this field should be passed back unchanged.")
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @JsonIgnore
    public boolean isNotificationEmailSettingsPopulated() {
        return !StringUtils.isBlank((String)this.emailServer) && !StringUtils.isBlank((String)this.sourceAddr);
    }
}

