/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.translator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.model.oauth.ClientAuth;
import com.pingidentity.admin.api.model.oauth.ClientAuthType;
import com.pingidentity.admin.api.model.oauth.ClientSecret;
import com.pingidentity.admin.api.model.oauth.TokenEndpointAuthSigningAlgorithm;
import com.pingidentity.admin.api.translator.SecondarySecretsTranslator;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Password;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.json.JsonUtils;

public class ClientAuthTranslator {
    protected static final String ENCODED_SECRET = "encoded";
    protected static final String REVERSIBLE_SECRET = "reversible";
    private List<ValidationError> validationErrors = null;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private static final ClientManager CLIENT_MGR = MgmtFactory.getClientManager();

    public ClientAuthTranslator(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public void apiToDomain(ClientAuth clientAuth, Client domainClient, String clientId) {
        if (clientAuth != null) {
            this.translateSecret(new ClientSecret(clientAuth.getSecret(), clientAuth.getEncryptedSecret()), domainClient, clientId);
            SecondarySecretsTranslator secondarySecretsTranslator = new SecondarySecretsTranslator(this.validationErrors);
            secondarySecretsTranslator.apiToDomain(clientAuth.getSecondarySecrets(), domainClient);
        }
        if (clientAuth != null && clientAuth.getType() != null) {
            switch (clientAuth.getType()) {
                case CERTIFICATE: {
                    domainClient.setClientCertIssuerDn(clientAuth.getClientCertIssuerDn());
                    domainClient.setClientCertSubjectDn(clientAuth.getClientCertSubjectDn());
                    domainClient.setClientAuthnType(ClientAuthenticationType.CLIENT_CERT);
                    break;
                }
                case SECRET: {
                    domainClient.setClientAuthnType(ClientAuthenticationType.SECRET);
                    break;
                }
                case PRIVATE_KEY_JWT: {
                    domainClient.setClientAuthnType(ClientAuthenticationType.PRIVATE_KEY_JWT);
                    domainClient.setEnforceReplayPrevention(clientAuth.isEnforceReplayPrevention());
                    String tokenEndpointAuthSigningAlgorithm = clientAuth.getTokenEndpointAuthSigningAlgorithm() != null ? clientAuth.getTokenEndpointAuthSigningAlgorithm().getId() : null;
                    domainClient.setTokenEndpointAuthSigningAlgorithm(tokenEndpointAuthSigningAlgorithm);
                    break;
                }
                case CLIENT_SECRET_JWT: {
                    domainClient.setClientAuthnType(ClientAuthenticationType.CLIENT_SECRET_JWT);
                    domainClient.setEnforceReplayPrevention(clientAuth.isEnforceReplayPrevention());
                    String tokenEndpointAuthSymmetricSigningAlg = clientAuth.getTokenEndpointAuthSigningAlgorithm() != null ? clientAuth.getTokenEndpointAuthSigningAlgorithm().getId() : null;
                    domainClient.setTokenEndpointAuthSigningAlgorithm(tokenEndpointAuthSymmetricSigningAlg);
                    break;
                }
                case NONE: {
                    domainClient.setClientAuthnType(ClientAuthenticationType.NONE);
                }
            }
        }
    }

    public ClientAuth domainToApi(Client domainClient) {
        TokenEndpointAuthSigningAlgorithm algorithm;
        ClientAuthType type;
        ClientAuth clientAuth = null;
        if (domainClient.getClientAuthnType() != null && (type = ClientAuthType.getApiClientAuth(domainClient.getClientAuthnType())) != null) {
            clientAuth = new ClientAuth(type);
        }
        if (StringUtils.isNotBlank((String)domainClient.getClientCertIssuerDn()) && StringUtils.isNotBlank((String)domainClient.getClientCertSubjectDn())) {
            if (clientAuth == null) {
                clientAuth = new ClientAuth(ClientAuthType.CERTIFICATE);
            }
            clientAuth.setClientCertIssuerDn(domainClient.getClientCertIssuerDn());
            clientAuth.setClientCertSubjectDn(domainClient.getClientCertSubjectDn());
        } else if (ClientAuthenticationType.PRIVATE_KEY_JWT == domainClient.getClientAuthnType()) {
            if (clientAuth == null) {
                clientAuth = new ClientAuth(ClientAuthType.PRIVATE_KEY_JWT);
            }
            clientAuth.setEnforceReplayPrevention(domainClient.isEnforceReplayPrevention());
            algorithm = TokenEndpointAuthSigningAlgorithm.getType(domainClient.getTokenEndpointAuthSigningAlgorithm());
            clientAuth.setTokenEndpointAuthSigningAlgorithm(algorithm);
        } else if (ClientAuthenticationType.CLIENT_SECRET_JWT == domainClient.getClientAuthnType()) {
            if (clientAuth == null) {
                clientAuth = new ClientAuth(ClientAuthType.CLIENT_SECRET_JWT);
            }
            clientAuth.setEnforceReplayPrevention(domainClient.isEnforceReplayPrevention());
            algorithm = TokenEndpointAuthSigningAlgorithm.getType(domainClient.getTokenEndpointAuthSigningAlgorithm());
            clientAuth.setTokenEndpointAuthSigningAlgorithm(algorithm);
        } else if (StringUtils.isNotBlank((String)domainClient.getEncodedSecret()) && clientAuth == null) {
            clientAuth = new ClientAuth(ClientAuthType.SECRET);
        }
        if (clientAuth == null) {
            clientAuth = new ClientAuth(ClientAuthType.NONE);
        }
        clientAuth.setEncryptedSecret(this.makeEncryptedSecret(domainClient));
        SecondarySecretsTranslator secondarySecretsTranslator = new SecondarySecretsTranslator(this.validationErrors);
        clientAuth.setSecondarySecrets(secondarySecretsTranslator.domainToApi(domainClient));
        return clientAuth;
    }

    private String makeEncryptedSecret(Client domainClient) {
        String encodedSecret = domainClient.getEncodedSecret();
        String reversibleSecret = domainClient.getReversableSecretAsString();
        if (encodedSecret == null && reversibleSecret == null) {
            return null;
        }
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        if (reversibleSecret != null) {
            jsonObj.put(REVERSIBLE_SECRET, reversibleSecret);
        } else if (encodedSecret != null) {
            jsonObj.put(ENCODED_SECRET, encodedSecret);
        }
        try {
            String jsonStr = JsonUtils.getInstance().writeValueAsString(jsonObj);
            return Password.obfuscateAndEncode((String)jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void translateSecret(ClientSecret secret, Client domainClient, String clientId) {
        domainClient.setForceSecretChange(Boolean.valueOf(true));
        if (StringUtils.isNotBlank((String)secret.getSecret())) {
            domainClient.updateSecret(secret.getSecret());
        } else if (StringUtils.isNotBlank((String)secret.getEncryptedSecret())) {
            String encryptedSecret = secret.getEncryptedSecret();
            String decrypted = EncryptedFieldValidator.decryptCiphertext(encryptedSecret);
            if (decrypted == null) {
                this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_clientauth_encrypted_secret_invalid, ClientPaths.getEncryptedSecret()));
            } else {
                Map<String, Object> jsonObj = this.getJsonObject(decrypted);
                if (jsonObj == null) {
                    this.validationErrors.add(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_clientauth_encrypted_secret_invalid, ClientPaths.getEncryptedSecret()));
                } else {
                    String encodedSecret = (String)jsonObj.get(ENCODED_SECRET);
                    String reversibleSecret = (String)jsonObj.get(REVERSIBLE_SECRET);
                    if (reversibleSecret != null) {
                        String existingSecret;
                        Client existingClient = CLIENT_MGR.getClient(clientId);
                        if (existingClient != null && (existingSecret = existingClient.getReversableSecretAsString()) != null && existingSecret.equals(reversibleSecret)) {
                            domainClient.setForceSecretChange(Boolean.valueOf(false));
                        }
                        domainClient.updateSecret(reversibleSecret);
                    } else if (encodedSecret != null) {
                        domainClient.updateEncodedSecret(encodedSecret);
                    }
                }
            }
        } else {
            domainClient.updateSecret(null);
        }
        domainClient.setClientAuthnType(domainClient.getClientAuthnType());
    }

    private Map<String, Object> getJsonObject(String decrypted) {
        if (StringUtils.isBlank((String)decrypted)) {
            return null;
        }
        try {
            return JsonUtils.getInstance().readToMap(decrypted);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

