/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeRule;
import com.pingidentity.admin.api.model.AttributeRules;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.AuthnSelectorPolicyAction;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyTreeNodePaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AbstractActionValidator
extends CompositeValidator {
    protected ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    protected ActionValidatorInfo validatorInfo;
    private final AuthnSelectorManager authnSelectorManager = MgmtFactory.getAuthnSelectorManager();

    protected abstract boolean isActionAllowed();

    protected abstract boolean needsChildren();

    public AbstractActionValidator(ActionValidatorInfo info) {
        this.validatorInfo = info;
    }

    @Override
    public boolean validate() {
        String context = this.validatorInfo.getAction().getContext();
        if (this.validatorInfo.getParentNodeAction() == null) {
            if (StringUtils.isNotBlank((String)context)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_context_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getType())));
            }
        } else if (context == null || StringUtils.isBlank((String)context)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_context_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getContext())));
        }
        if (this.needsChildren()) {
            if (this.validatorInfo.getChildren() == null || this.validatorInfo.getChildren().isEmpty()) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_type_children_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getType())));
            } else {
                ArrayList<PolicyAction> childrenActions = new ArrayList<PolicyAction>();
                for (AuthenticationPolicyTreeNode child : this.validatorInfo.getChildren()) {
                    if (child.getAction() == null || child.getAction().getContext() == null) continue;
                    childrenActions.add(child.getAction());
                }
                UniqueEntriesValidator.UniqueKeyGetter<PolicyAction> policyActionUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<PolicyAction>(){

                    @Override
                    public String getKey(PolicyAction object) {
                        if (object.getContext() != null) {
                            return object.getContext();
                        }
                        return null;
                    }
                };
                this.addValidator((Validator)new UniqueEntriesValidator<PolicyAction>(policyActionUniqueKeyGetter, childrenActions, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getChildren()), ApiMessageKey.authn_policy_action_duplicate_children_action_contexts));
            }
        } else if (this.validatorInfo.getChildren() != null && !this.validatorInfo.getChildren().isEmpty()) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_type_children_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getType())));
        }
        if (!this.isActionAllowed()) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_type_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getType())));
        }
        this.validateContextValue();
        super.validate();
        return !this.hasErrors();
    }

    private void validateContextValue() {
        AuthnSelectorInstance domainInstance;
        String selectorId;
        ResourceLink authnSelectorRef;
        if (this.validatorInfo.getParentNodeAction() != null && this.validatorInfo.getParentNodeAction() instanceof AuthnSelectorPolicyAction && this.validatorInfo.getAction().getContext() != null && (authnSelectorRef = ((AuthnSelectorPolicyAction)this.validatorInfo.getParentNodeAction()).getAuthenticationSelectorRef()) != null && (selectorId = authnSelectorRef.getId()) != null && (domainInstance = this.getDomainAuthnSelector(selectorId)) != null) {
            ArrayList selectorAttributes = new ArrayList(domainInstance.getAttributeContract().getAllAttributeNames());
            if (!selectorAttributes.contains(this.validatorInfo.getAction().getContext())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_children_invalid_for_authn_selector_action, this.makeFieldPath(AuthenticationPolicyActionPaths.getContext()), new Object[]{this.validatorInfo.getAction().getContext()}));
            }
            if (domainInstance.isAnyEnabled() && !this.validatorInfo.getAction().getContext().equalsIgnoreCase("Not in Request") && !this.validatorInfo.getAction().getContext().equalsIgnoreCase("No Match") && !this.validatorInfo.getAction().getContext().equalsIgnoreCase("Any")) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_context_invalid_for_authn_selector_configuration_any, this.makeFieldPath(AuthenticationPolicyActionPaths.getContext()), new Object[]{this.validatorInfo.getAction().getContext()}));
            }
        }
        if (this.validatorInfo.getParentNodeAction() != null && this.validatorInfo.getParentNodeAction() instanceof AuthnSourcePolicyAction && this.validatorInfo.getAction().getContext() != null) {
            AuthnSourcePolicyAction authnSourcePolicyAction = (AuthnSourcePolicyAction)this.validatorInfo.getParentNodeAction();
            AttributeRules attributeRules = authnSourcePolicyAction.getAttributeRules();
            ArrayList<String> allowedContextValues = new ArrayList<String>();
            allowedContextValues.add("Success");
            allowedContextValues.add("Fail");
            if (attributeRules != null && attributeRules.getItems() != null && !attributeRules.getItems().isEmpty()) {
                List<AttributeRule> attributeRuleList = attributeRules.getItems();
                for (AttributeRule attributeRule : attributeRuleList) {
                    allowedContextValues.add(attributeRule.getResult());
                }
            }
            if (!allowedContextValues.contains(this.validatorInfo.getAction().getContext())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_child_invalid_for_authn_source_action, this.makeFieldPath(AuthenticationPolicyActionPaths.getContext()), new Object[]{this.validatorInfo.getAction().getContext()}));
            }
        }
    }

    protected AuthnSelectorInstance getDomainAuthnSelector(String selectorId) {
        AuthnSelectorInstance domainInstance = (AuthnSelectorInstance)this.authnSelectorManager.getInstance(selectorId);
        return domainInstance;
    }

    protected String makeFieldPath(String suffix) {
        if (this.validatorInfo.getRootFieldPath() == null) {
            return suffix;
        }
        return this.validatorInfo.getRootFieldPath() + "." + suffix;
    }
}

