/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.AccessTokenManagementSettingsPaths;
import com.pingidentity.admin.api.model.oauth.AccessTokenManagementSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AccessTokenManagementSettingsValidator
extends AbstractValidator {
    private AccessTokenManagementSettings settings;
    private BearerAccessTokenMgmtPluginInstance defaultInstance = null;
    private BearerAccessTokenMgmtPluginManager pluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public AccessTokenManagementSettingsValidator(AccessTokenManagementSettings settings) {
        this.settings = settings;
    }

    public boolean validate() {
        if (this.settings.getDefaultAccessTokenManagerRef() != null && this.settings.getDefaultAccessTokenManagerRef().getId() != null) {
            String defaultInstanceId = this.settings.getDefaultAccessTokenManagerRef().getId();
            this.defaultInstance = (BearerAccessTokenMgmtPluginInstance)this.pluginManager.getInstance(defaultInstanceId);
            if (this.defaultInstance == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_access_token_management_default_manager_id_invalid, AccessTokenManagementSettingsPaths.getDefaultAccessTokenManagerRefId(), new Object[]{defaultInstanceId}));
            }
        } else if (!this.pluginManager.getInstances().isEmpty()) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_access_token_management_default_manager_required, AccessTokenManagementSettingsPaths.getDefaultAccessTokenManagerRefId()));
        }
        return !this.hasErrors();
    }

    public BearerAccessTokenMgmtPluginInstance getDefaultInstance() {
        return this.defaultInstance;
    }
}

