/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.AccountLinkSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;

public class AccountLinkSourceTypeValidator
extends AbstractValidator {
    private final String attributeName;
    private final String value;
    private final String fieldPath;
    private final boolean isLinkingEnabled;
    private final AccountLinkSourceTypeMsgContext msgContext;

    AccountLinkSourceTypeValidator(String attributeName, String value, boolean isLinkingEnabled, String fieldPath, AccountLinkSourceTypeMsgContext msgContext) {
        this.attributeName = attributeName;
        this.value = value;
        this.isLinkingEnabled = isLinkingEnabled;
        this.fieldPath = fieldPath;
        this.msgContext = msgContext;
    }

    public boolean validate() {
        Set<String> expectedVars;
        ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
        if (!this.isLinkingEnabled) {
            this.appendError(errorFactory.create(this.msgContext.getNotEnabledKey(), this.fieldPath, new Object[]{this.attributeName}));
        }
        if (!(expectedVars = AccountLinkSourceTypeValidatorBuilder.getExpectedValues()).contains(this.value)) {
            this.appendError(errorFactory.create(this.msgContext.getBadValueKey(), this.fieldPath, new Object[]{this.value, expectedVars.iterator().next(), this.attributeName}));
        }
        return !this.hasErrors();
    }

    public static enum AccountLinkSourceTypeMsgContext {
        ATTR_MAPPING{

            @Override
            public ApiMessageKey getBadValueKey() {
                return ApiMessageKey.mapping_source_type_account_linking_bad_value;
            }

            @Override
            public ApiMessageKey getNotEnabledKey() {
                return ApiMessageKey.mapping_source_type_account_linking_not_enabled;
            }
        }
        ,
        ISSUANCE_CRITERIA{

            @Override
            public ApiMessageKey getBadValueKey() {
                return ApiMessageKey.issuance_criteria_source_type_account_linking_bad_value;
            }

            @Override
            public ApiMessageKey getNotEnabledKey() {
                return ApiMessageKey.issuance_criteria_source_type_account_linking_not_enabled;
            }
        };


        public abstract ApiMessageKey getBadValueKey();

        public abstract ApiMessageKey getNotEnabledKey();
    }
}

