/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.AccountLinkSourceTypeValidator;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.IdpConnection;

public class AccountLinkSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private boolean isLinkingEnabled;
    private static final Set<String> EXPECTED_VALUES = new HashSet<String>();

    public static Set<String> getExpectedValues() {
        return Collections.unmodifiableSet(EXPECTED_VALUES);
    }

    public boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public void setLinkingEnabled(boolean isLinkingEnabled) {
        this.isLinkingEnabled = isLinkingEnabled;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), SourceType.ACCOUNT_LINK);
        return new AccountLinkSourceTypeValidator(attributeName, afv.getValue(), this.isLinkingEnabled, attributePath, AccountLinkSourceTypeValidator.AccountLinkSourceTypeMsgContext.ATTR_MAPPING);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), SourceType.ACCOUNT_LINK);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new AccountLinkSourceTypeValidator(null, icEntry.getAttributeName(), this.isLinkingEnabled, attributePath, AccountLinkSourceTypeValidator.AccountLinkSourceTypeMsgContext.ISSUANCE_CRITERIA), icEntry, attributePath);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return AccountLinkSourceTypeValidatorBuilder.getExpectedValues();
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    static {
        EXPECTED_VALUES.add(IdpConnection.getLocalIdSubstitutionKey());
    }
}

