/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.Entity;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;
import org.sourceid.common.ValidationUtil;

public class AdditionalAllowedEntitiesConfigurationValidator
extends AbstractValidator {
    public Connection connection;

    AdditionalAllowedEntitiesConfigurationValidator(Connection apiIdpConnection) {
        this.connection = apiIdpConnection;
    }

    private boolean isAllowAdditionalEntities() {
        return this.connection.getAdditionalAllowedEntitiesConfiguration() != null && this.connection.getAdditionalAllowedEntitiesConfiguration().isAllowAdditionalEntities();
    }

    private boolean isAllowAllEntities() {
        return this.connection.getAdditionalAllowedEntitiesConfiguration() != null && this.connection.getAdditionalAllowedEntitiesConfiguration().isAllowAllEntities();
    }

    private boolean hasAdditionalAllowedEntities() {
        return this.connection.getAdditionalAllowedEntitiesConfiguration() != null && !this.connection.getAdditionalAllowedEntitiesConfiguration().getAdditionalAllowedEntities().isEmpty();
    }

    private boolean isRedundantWhiteListing() {
        return this.isAllowAdditionalEntities() && this.isAllowAllEntities() && this.hasAdditionalAllowedEntities();
    }

    private void validateAdditionalAllowedEntities() {
        if (this.connection.getAdditionalAllowedEntitiesConfiguration() != null) {
            List<Entity> additionalEntities = this.connection.getAdditionalAllowedEntitiesConfiguration().getAdditionalAllowedEntities();
            HashSet<String> entityIdSet = new HashSet<String>();
            for (int i = 0; i < additionalEntities.size(); ++i) {
                Entity entity = additionalEntities.get(i);
                if (entity.getEntityId().equals(this.connection.getEntityId())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_primary_issuer_always_accepted, ConnectionPaths.getAdditionalAllowedEntities(i)));
                }
                if (!ValidationUtil.isValidHttpsUrl((String)entity.getEntityId())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_issuer_invalid, ConnectionPaths.getAdditionalAllowedEntities(i)));
                }
                if (entityIdSet.add(additionalEntities.get(i).getEntityId())) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_duplicate_entry, ConnectionPaths.getAdditionalAllowedEntities(i), new Object[]{additionalEntities.get(i).getEntityId()}));
            }
        }
    }

    private void validateConfigurationConsistency() {
        if (this.isRedundantWhiteListing()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_accept_all_issuers_enabled, ConnectionPaths.getAdditionalAllowedEntities()));
        } else if (!this.isAllowAdditionalEntities()) {
            if (this.isAllowAllEntities()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_additional_issuers_enabled_only, ConnectionPaths.getAllowAllEntities(), new Object[]{"allowAllEntitiesEnabled", "false"}));
            }
            if (this.hasAdditionalAllowedEntities()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.openid_connect_additional_issuers_enabled_only, ConnectionPaths.getAdditionalAllowedEntities(), new Object[]{"additionalAllowedEntities", "empty array"}));
            }
        }
        this.validateAdditionalAllowedEntities();
    }

    public boolean validate() {
        if (this.connection.getBrowserSso() != null && this.connection.getBrowserSso().getProtocol() == Protocol.OIDC && this.connection.getType().equals((Object)ConnectionType.IDP)) {
            this.validateConfigurationConsistency();
        }
        if (!(!this.connection.isAdditionalAllowedEntitiesConfigured() || this.connection.getBrowserSso() != null && this.connection.getBrowserSso().getProtocol().equals((Object)Protocol.OIDC) && this.connection.getType().equals((Object)ConnectionType.IDP))) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getAdditionalAllowedEntitiesConfiguration(), new Object[]{ConnectionPaths.getAdditionalAllowedEntitiesConfiguration()}));
        }
        return !this.hasErrors();
    }
}

