/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.JdbcDataStore;
import com.pingidentity.admin.api.model.fieldpaths.JdbcDataStorePaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.sourceid.common.ValidationUtil;

public class AdvancedJdbcDataStoreValidator
extends AbstractValidator {
    private final String minPoolSize;
    private final String maxPoolSize;
    private final String blockingTimeout;
    private final String idleTimeout;

    private AdvancedJdbcDataStoreValidator(Builder builder) {
        this.minPoolSize = builder.minPoolSize;
        this.maxPoolSize = builder.maxPoolSize;
        this.blockingTimeout = builder.blockingTimeout;
        this.idleTimeout = builder.idleTimeout;
    }

    public boolean validate() {
        boolean validMinPoolSize = true;
        if (!ValidationUtil.isValidInt((String)this.minPoolSize)) {
            validMinPoolSize = false;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_invalid_min_pool_size, JdbcDataStorePaths.getMinPoolSize()));
        } else {
            int minPoolSizeInt = Integer.parseInt(this.minPoolSize);
            if (minPoolSizeInt < 0) {
                validMinPoolSize = false;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_negative_min_pool_size, JdbcDataStorePaths.getMinPoolSize(), new Object[]{"0"}));
            }
        }
        boolean validMaxPoolSize = true;
        if (!ValidationUtil.isValidInt((String)this.maxPoolSize)) {
            validMaxPoolSize = false;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_invalid_max_pool_size, JdbcDataStorePaths.getMaxPoolSize()));
        } else {
            int maxPoolSizeInt = Integer.parseInt(this.maxPoolSize);
            if (maxPoolSizeInt < 0) {
                validMaxPoolSize = false;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_negative_max_pool_size, JdbcDataStorePaths.getMaxPoolSize(), new Object[]{"0"}));
            }
        }
        if (!ValidationUtil.isValidInt((String)this.blockingTimeout)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_invalid_blocking_timeout, JdbcDataStorePaths.getBlockingTimeout()));
        } else {
            int blockingTimeoutInt = Integer.parseInt(this.blockingTimeout);
            if (blockingTimeoutInt < -1) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_invalid_min_blocking_timeout, JdbcDataStorePaths.getBlockingTimeout(), new Object[]{"-1"}));
            }
        }
        if (!ValidationUtil.isValidInt((String)this.idleTimeout)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_invalid_idle_timeout, JdbcDataStorePaths.getIdleTimeout()));
        } else {
            int idleTimeoutInt = Integer.parseInt(this.idleTimeout);
            if (idleTimeoutInt < 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_negative_idle_timeout, JdbcDataStorePaths.getIdleTimeout(), new Object[]{"0"}));
            }
        }
        if (validMinPoolSize && validMaxPoolSize && Integer.parseInt(this.minPoolSize) > Integer.parseInt(this.maxPoolSize)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_jdbc_data_store_max_pool_size_lesser_than_min_pool_size, JdbcDataStorePaths.getMinPoolSize()));
        }
        return !this.hasErrors();
    }

    public static class Builder {
        String minPoolSize;
        String maxPoolSize;
        String blockingTimeout;
        String idleTimeout;

        public Builder withDataStore(JdbcDataStore dataStore) {
            if (dataStore.getMinPoolSize() != null) {
                this.minPoolSize = String.valueOf(dataStore.getMinPoolSize());
            }
            if (dataStore.getMaxPoolSize() != null) {
                this.maxPoolSize = String.valueOf(dataStore.getMaxPoolSize());
            }
            if (dataStore.getBlockingTimeout() != null) {
                this.blockingTimeout = String.valueOf(dataStore.getBlockingTimeout());
            }
            if (dataStore.getIdleTimeout() != null) {
                this.idleTimeout = String.valueOf(dataStore.getIdleTimeout());
            }
            return this;
        }

        public Builder setMinPoolSize(String minPoolSize) {
            this.minPoolSize = minPoolSize;
            return this;
        }

        public Builder setMaxPoolSize(String maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder setBlockingTimeout(String blockingTimeout) {
            this.blockingTimeout = blockingTimeout;
            return this;
        }

        public Builder setIdleTimeout(String idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public AdvancedJdbcDataStoreValidator build() {
            return new AdvancedJdbcDataStoreValidator(this);
        }
    }
}

