/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.LdapDataStore;
import com.pingidentity.admin.api.model.fieldpaths.LdapDataStorePaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class AdvancedLdapDataStoreValidator
extends AbstractValidator {
    private final String minConnections;
    private final String maxConnections;
    private final String maxWait;
    private final String timeBetweenEvictions;
    private final String readTimeout;
    private final String connectionTimeout;
    private final String dnsTtl;
    private String ldapDnsSrvPrefix;
    private String ldapsDnsSrvPrefix;
    private final List<String> binaryAttributes;

    private AdvancedLdapDataStoreValidator(Builder builder) {
        this.minConnections = builder.minConnections;
        this.maxConnections = builder.maxConnections;
        this.maxWait = builder.maxWait;
        this.timeBetweenEvictions = builder.timeBetweenEvictions;
        this.readTimeout = builder.readTimeout;
        this.connectionTimeout = builder.connectionTimeout;
        this.binaryAttributes = builder.binaryAttributes;
        this.ldapDnsSrvPrefix = builder.ldapDnsSrvPrefix;
        this.ldapsDnsSrvPrefix = builder.ldapsDnsSrvPrefix;
        this.dnsTtl = builder.dnsTtl;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.minConnections) || !ValidationUtil.isValidNonZeroPosInt((String)this.minConnections)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_min_connections, LdapDataStorePaths.getMinConnections()));
        } else if (StringUtils.isBlank((String)this.maxConnections) || !this.isValidMax(this.maxConnections, this.minConnections)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_max_connections, LdapDataStorePaths.getMaxConnections()));
        }
        if (StringUtils.isBlank((String)this.maxWait) || !ValidationUtil.isValidInt((String)this.maxWait, (int)-1)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_max_wait, LdapDataStorePaths.getMaxWait()));
        }
        if (StringUtils.isBlank((String)this.timeBetweenEvictions) || !ValidationUtil.isValidInt((String)this.timeBetweenEvictions, (int)-1)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_time_between_evictions, LdapDataStorePaths.getTimeBetweenEvictions()));
        }
        if (StringUtils.isBlank((String)this.readTimeout) || !ValidationUtil.isValidInt((String)this.readTimeout, (int)-1)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_read_timeout, LdapDataStorePaths.getReadTimeout()));
        }
        if (StringUtils.isBlank((String)this.connectionTimeout) || !ValidationUtil.isValidInt((String)this.connectionTimeout, (int)-1)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_connection_timeout, LdapDataStorePaths.getConnectionTimeout()));
        }
        if (StringUtils.isBlank((String)this.dnsTtl) || !ValidationUtil.isValidInt((String)this.dnsTtl, (int)0)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_invalid_dns_ttl, LdapDataStorePaths.getDnsTtl()));
        }
        if (StringUtils.isBlank((String)this.ldapDnsSrvPrefix)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_ldap_dns_srv_prefix_blank, LdapDataStorePaths.getLdapDnsSrvPrefix()));
        }
        if (StringUtils.isBlank((String)this.ldapsDnsSrvPrefix)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.advanced_ldap_data_store_ldaps_dns_srv_prefix_blank, LdapDataStorePaths.getLdapsDnsSrvPrefix()));
        }
        if (this.binaryAttributes != null) {
            int index = 0;
            for (String binaryAttribute : this.binaryAttributes) {
                if (StringUtils.isBlank((String)binaryAttribute)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_binary_attribute_blank, LdapDataStorePaths.getBinaryAttribute(index)));
                }
                ++index;
            }
        }
        return !this.hasErrors();
    }

    private boolean isValidMax(String max, String min) {
        try {
            int maxInt = Integer.parseInt(max);
            int minInt = Integer.parseInt(min);
            if (maxInt < minInt) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static class Builder {
        private String minConnections;
        private String maxConnections;
        private String maxWait;
        private String timeBetweenEvictions;
        private String readTimeout;
        private String connectionTimeout;
        private String dnsTtl;
        private String ldapDnsSrvPrefix;
        private String ldapsDnsSrvPrefix;
        private List<String> binaryAttributes;

        public Builder() {
            LdapInfo ldapInfo = new LdapInfo();
            this.minConnections = String.valueOf(ldapInfo.getMin());
            this.maxConnections = String.valueOf(ldapInfo.getMax());
            this.maxWait = String.valueOf(ldapInfo.getMaxWait());
            this.timeBetweenEvictions = String.valueOf(ldapInfo.getTimeBetweenEvictionRunsMillis());
            this.readTimeout = String.valueOf(ldapInfo.getReadTimeoutMillis());
            this.connectionTimeout = String.valueOf(ldapInfo.getConnTimeoutMillis());
            this.dnsTtl = String.valueOf(ldapInfo.getDnsTtlMillis());
            this.ldapDnsSrvPrefix = ldapInfo.getLdapDnsSrvPrefix();
            this.ldapsDnsSrvPrefix = ldapInfo.getLdapsDnsSrvPrefix();
        }

        public Builder withDataStore(LdapDataStore dataStore) {
            if (dataStore.getMinConnections() != null) {
                this.minConnections = String.valueOf(dataStore.getMinConnections());
            }
            if (dataStore.getMaxConnections() != null) {
                this.maxConnections = String.valueOf(dataStore.getMaxConnections());
            }
            if (dataStore.getMaxWait() != null) {
                this.maxWait = String.valueOf(dataStore.getMaxWait());
            }
            if (dataStore.getTimeBetweenEvictions() != null) {
                this.timeBetweenEvictions = String.valueOf(dataStore.getTimeBetweenEvictions());
            }
            if (dataStore.getReadTimeout() != null) {
                this.readTimeout = String.valueOf(dataStore.getReadTimeout());
            }
            if (dataStore.getConnectionTimeout() != null) {
                this.connectionTimeout = String.valueOf(dataStore.getConnectionTimeout());
            }
            if (dataStore.getBinaryAttributes() != null) {
                this.binaryAttributes = dataStore.getBinaryAttributes();
            }
            if (dataStore.getDnsTtl() != null) {
                this.dnsTtl = String.valueOf(dataStore.getDnsTtl());
            }
            if (dataStore.getLdapDnsSrvPrefix() != null) {
                this.ldapDnsSrvPrefix = dataStore.getLdapDnsSrvPrefix();
            }
            if (dataStore.getLdapsDnsSrvPrefix() != null) {
                this.ldapsDnsSrvPrefix = dataStore.getLdapsDnsSrvPrefix();
            }
            return this;
        }

        public Builder setMinConnections(String minConnections) {
            this.minConnections = minConnections;
            return this;
        }

        public Builder setMaxConnections(String maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxWait(String maxWait) {
            this.maxWait = maxWait;
            return this;
        }

        public Builder setTimeBetweenEvictions(String timeBetweenEvictions) {
            this.timeBetweenEvictions = timeBetweenEvictions;
            return this;
        }

        public Builder setReadTimeout(String readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setConnectionTimeout(String connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setDnsTtl(String dnsTtl) {
            this.dnsTtl = dnsTtl;
            return this;
        }

        public Builder setLdapDnsSrvPrefix(String ldapDnsSrvPrefix) {
            this.ldapDnsSrvPrefix = ldapDnsSrvPrefix;
            return this;
        }

        public Builder setLdapsDnsSrvPrefix(String ldapsDnsSrvPrefix) {
            this.ldapsDnsSrvPrefix = ldapsDnsSrvPrefix;
            return this;
        }

        public Builder setBinaryAttributes(List<String> binaryAttributes) {
            this.binaryAttributes = binaryAttributes;
            return this;
        }

        public AdvancedLdapDataStoreValidator build() {
            return new AdvancedLdapDataStoreValidator(this);
        }
    }
}

