/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ApcToSpAdapterMapping;
import com.pingidentity.admin.api.model.fieldpaths.GenericMappingsPaths;
import com.pingidentity.admin.api.validator.ApcToSpAdapterAttributeMappingValidator;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;

public class ApcToSpAdapterMappingValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final ApcToSpAdapterMapping mappingToValidate;
    C2cContractManager apcManager;
    SpAdapterManager spAdapterManager;
    Apc2SpAdapterManager apc2SpAdapterMgr;
    ValidatorContext context;

    public ApcToSpAdapterMappingValidator(ApcToSpAdapterMapping mappingToValidate, C2cContractManager apcManager, SpAdapterManager spAdapterManager, Apc2SpAdapterManager apc2SpAdapterMgr, ValidatorContext context) {
        this.mappingToValidate = mappingToValidate;
        this.apcManager = apcManager;
        this.spAdapterManager = spAdapterManager;
        this.apc2SpAdapterMgr = apc2SpAdapterMgr;
        this.context = context;
    }

    public boolean validate() {
        HttpUrlValidator httpValidator;
        String targetId;
        AuthnAdapterInstance targetSpAdapter;
        this.checkForRequiredFields();
        if (this.hasErrors()) {
            return false;
        }
        String sourceId = this.mappingToValidate.getSourceId();
        C2cContract sourceApc = this.apcManager.getContract(sourceId);
        if (sourceApc == null || !sourceApc.getId().equals(sourceId)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.apc_to_sp_adapter_mappings_source_doesnt_exist, GenericMappingsPaths.getSourceId(), new Object[]{this.mappingToValidate.getSourceId()}));
        }
        if ((targetSpAdapter = (AuthnAdapterInstance)this.spAdapterManager.getInstance(targetId = this.mappingToValidate.getTargetId())) == null || !targetSpAdapter.getId().equals(targetId)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.apc_to_sp_adapter_mappings_target_doesnt_exist, GenericMappingsPaths.getTargetId(), new Object[]{this.mappingToValidate.getTargetId()}));
        }
        if (this.hasErrors()) {
            return !this.hasErrors();
        }
        this.checkForDuplicateMapping();
        ApcToSpAdapterAttributeMappingValidator attributeMappingValidator = new ApcToSpAdapterAttributeMappingValidator(this.mappingToValidate, (AttributeContract)sourceApc, targetSpAdapter.getAttributeContract(), "", this.context);
        if (!attributeMappingValidator.validate()) {
            super.getErrors().addAll(attributeMappingValidator.getErrors());
        }
        if (!(httpValidator = new HttpUrlValidator(this.mappingToValidate.getDefaultTargetResource(), true, GenericMappingsPaths.getDefaultTargetResource())).validate()) {
            super.getErrors().addAll(httpValidator.getErrors());
        }
        return !this.hasErrors();
    }

    void checkForRequiredFields() {
        if (this.mappingToValidate.getSourceId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, GenericMappingsPaths.getSourceId(), new Object[]{"Authentication Policy Contract ID"}));
        }
        if (this.mappingToValidate.getTargetId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, GenericMappingsPaths.getTargetId(), new Object[]{"SP Adapter ID"}));
        }
    }

    void checkForDuplicateMapping() {
        if (!this.context.isUpdateRequest() && this.apc2SpAdapterMgr.getMapping(this.mappingToValidate.getSourceId(), this.mappingToValidate.getTargetId()) != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.apc_to_sp_adapter_mappings_duplicate_mappings, GenericMappingsPaths.getId(), new Object[]{this.mappingToValidate.getSourceId(), this.mappingToValidate.getTargetId()}));
        }
    }
}

