/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.metadata.Role;

public class ArtifactLifetimeValidator
extends AbstractValidator {
    private final String artifactLifetime;

    public ArtifactLifetimeValidator(String artifactLifetime) {
        this.artifactLifetime = artifactLifetime;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.artifactLifetime)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.artifact_lifetime_required, ConnectionPaths.getArtifactLifetimePropertyPath(Role.SP)));
        }
        if (!ValidationUtil.isValidNonZeroPosInt((String)this.artifactLifetime) || Integer.parseInt(this.artifactLifetime) > 180) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.artifact_lifetime_out_of_range, ConnectionPaths.getArtifactLifetimePropertyPath(Role.SP)));
        }
        return !this.hasErrors();
    }
}

