/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ArtifactResolverLocation;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.ArtifactResolverUrlIndexValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.metadata.Role;

public class ArtifactResolverLocationValidator
extends AbstractValidator {
    private final List<ArtifactResolverLocation> endpoints;
    private final boolean isBaseUrlDefined;
    private final String baseUrl;
    private final Role role;
    private final Protocol protocol;

    public ArtifactResolverLocationValidator(List<ArtifactResolverLocation> endpoints, String baseUrl, Role role, Protocol protocol) {
        this.endpoints = endpoints;
        this.baseUrl = baseUrl;
        this.isBaseUrlDefined = baseUrl != null;
        this.role = role;
        this.protocol = protocol;
    }

    public boolean validate() {
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.artifact_resolver_location_empty, ConnectionPaths.getArtifactResolverLocationsPropertyPath(this.role)));
            return false;
        }
        if (!Protocol.isSaml1x(this.protocol)) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 0; i < this.endpoints.size(); ++i) {
                indexes.add(this.endpoints.get(i).getIndex());
            }
            ArtifactResolverUrlIndexValidator indexValidator = new ArtifactResolverUrlIndexValidator(indexes, this.role);
            indexValidator.validate();
            this.appendErrors(indexValidator.getErrors());
        } else {
            if (this.endpoints.size() > 1) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getArtifactResolverLocationsPropertyPath(this.role)));
            }
            int endpointIndex = 0;
            for (int i = 0; i < this.endpoints.size(); ++i) {
                ArtifactResolverLocation endpoint = this.endpoints.get(endpointIndex);
                if (endpoint.getIndex() == null) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getArtifactResolverLocationsIndexPath(this.role, endpointIndex)));
            }
        }
        if (this.hasErrors()) {
            return false;
        }
        boolean missingUrlError = false;
        int i = 0;
        for (ArtifactResolverLocation location : this.endpoints) {
            if (location.getUrl() == null) {
                if (!missingUrlError) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.artifact_resolver_location_missing, ConnectionPaths.getArtifactResolverLocationsUrlPath(this.role, i)));
                    missingUrlError = true;
                }
            } else {
                String urlFieldPath = ConnectionPaths.getArtifactResolverLocationsUrlPath(this.role, i);
                this.validateUrl(location.getUrl(), urlFieldPath);
            }
            ++i;
        }
        if (this.anyRelativeUrls()) {
            URL baseUrlObject = this.stringToUrl(this.baseUrl);
            if (baseUrlObject != null) {
                int endpointIndex = 0;
                while (i < this.endpoints.size()) {
                    ArtifactResolverLocation endpoint = this.endpoints.get(endpointIndex);
                    if (!this.isProtocolConsistent(endpoint.getUrl())) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocols_must_match, ConnectionPaths.getArtifactResolverLocationsIndexPath(this.role, endpointIndex)));
                    }
                    ++i;
                }
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocols_must_match, ConnectionPaths.getArtifactResolverLocationsPropertyPath(this.role)));
            }
        } else if (!this.isProtocolConsistent(null)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocols_must_match, ConnectionPaths.getArtifactResolverLocationsPropertyPath(this.role)));
        }
        return !this.hasErrors();
    }

    private List<URL> artifactItemToUrlList() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ArtifactResolverLocation endpoint : this.endpoints) {
            Object temp = null;
            temp = ValidationUtil.startsWithForwardSlash((String)endpoint.getUrl()) && this.isBaseUrlDefined ? this.baseUrl + endpoint.getUrl() : endpoint.getUrl();
            urls.add(this.stringToUrl((String)temp));
        }
        return urls;
    }

    private boolean isProtocolConsistent(String testUrl) {
        List<URL> artifactListUrlList = this.artifactItemToUrlList();
        if (ValidationUtil.startsWithForwardSlash((String)testUrl) && this.isBaseUrlDefined) {
            testUrl = this.baseUrl + (String)testUrl;
        }
        return ValidationUtil.isUrlProtocolConsistentWithList(artifactListUrlList, (URL)this.stringToUrl((String)testUrl));
    }

    private boolean anyRelativeUrls() {
        for (URL endpoint : this.artifactItemToUrlList()) {
            if (endpoint != null) continue;
            return true;
        }
        return false;
    }

    private URL stringToUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void validateUrl(String url, String fieldPath) {
        PartnerUrlValidator urlValidator = PartnerUrlValidatorFactory.getBrowserArtifactResolverLocationValidator(url, this.isBaseUrlDefined, fieldPath);
        urlValidator.validate();
        this.getErrors().addAll(urlValidator.getErrors());
    }
}

