/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.ArtifactLifetimeValidator;
import com.pingidentity.admin.api.validator.ArtifactResolverLocationValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class ArtifactValidator
extends CompositeValidator {
    public ArtifactValidator(Connection connection, BaseBrowserSso browserSso) {
        if ((browserSso.isArtifactSsoSloUsed() || browserSso.isInboundArtifact()) && browserSso.getProtocol() != com.pingidentity.admin.api.model.Protocol.OIDC) {
            if (browserSso.getArtifact() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getArtifactPropertyPath(connection.getType().getRole()), new Object[]{ConnectionPaths.getArtifactPropertyPath(connection.getType().getRole())}));
            } else {
                this.addValidators(connection, browserSso);
            }
        } else if (browserSso.getArtifact() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getArtifactPropertyPath(connection.getType().getRole()), new Object[]{ConnectionPaths.getArtifactPropertyPath(connection.getType().getRole())}));
        }
    }

    private void addValidators(Connection connection, BaseBrowserSso browserSso) {
        if (browserSso.isArtifactSsoSloUsed()) {
            this.addValidator((Validator)new ArtifactLifetimeValidator(String.valueOf(browserSso.getArtifact().getLifetime())));
        } else if (browserSso.getArtifact().getLifetime() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.artifact_lifetime_not_required, ConnectionPaths.getArtifactLifetimePropertyPath(connection.getType().getRole())));
        }
        if (browserSso.isInboundArtifact()) {
            ArtifactResolverLocationValidator validator = new ArtifactResolverLocationValidator(browserSso.getArtifact().getResolverLocations(), connection.getBaseUrl(), connection.getType().getRole(), connection.getBrowserSso().getProtocol());
            this.addValidator((Validator)validator);
        } else if (browserSso.getArtifact().getResolverLocations() != null && !browserSso.getArtifact().getResolverLocations().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.artifact_resolver_location_not_required, ConnectionPaths.getArtifactResolverLocationsPropertyPath(connection.getType().getRole())));
        }
        if (!com.pingidentity.admin.api.model.Protocol.isSaml1x(browserSso.getProtocol()) && StringUtils.isNotBlank((String)browserSso.getArtifact().getSourceId())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole()), new Object[]{ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole())}));
        }
        if (com.pingidentity.admin.api.model.Protocol.isSaml1x(browserSso.getProtocol()) && StringUtils.isNotBlank((String)browserSso.getArtifact().getSourceId())) {
            if (HexBin.stringToBytes((String)browserSso.getArtifact().getSourceId()) == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.format_invalid, ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole()), new Object[]{ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole())}));
            }
            if (browserSso.getArtifact().getSourceId().length() != 40) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.format_invalid, ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole()), new Object[]{ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole())}));
            }
            if (MgmtFactory.getConnectionManager().isSourceIdInUse(browserSso.getArtifact().getSourceId(), connection.getEntityId(), new Protocol[]{Protocol.SAML11, Protocol.SAML10})) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.source_id_in_use, ConnectionPaths.getArtifactSourceIdPropertyPath(connection.getType().getRole())));
            }
        }
    }
}

