/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.List;

public class AttributeContractValidator<E extends Attribute>
extends CompositeValidator {
    protected Connection connection;

    public AttributeContractValidator(List<E> coreAttributes, List<E> extendedAttributes, String contractFieldPath) {
        UniqueEntriesValidator.UniqueKeyGetter attrKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<E>(){

            @Override
            public String getKey(Attribute object) {
                return object.getName();
            }
        };
        ArrayList<E> combinedList = new ArrayList<E>();
        if (coreAttributes != null) {
            combinedList.addAll(coreAttributes);
        }
        if (extendedAttributes != null) {
            combinedList.addAll(extendedAttributes);
        }
        this.addAdditionalValidators(combinedList, contractFieldPath, attrKeyGetter);
        String coreAttrPAth = ConnectionPaths.getCoreAttributes(contractFieldPath);
        this.addAttrValidators(coreAttributes, coreAttrPAth, attrKeyGetter);
        String extAttrPath = ConnectionPaths.getExtendedAttributesPath(contractFieldPath);
        this.addAttrValidators(extendedAttributes, extAttrPath, attrKeyGetter);
    }

    public AttributeContractValidator(List<E> coreAttributes, List<E> extendedAttributes, String contractFieldPath, SpConnection conn) {
        int i;
        UniqueEntriesValidator.UniqueKeyGetter attrKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<E>(){

            @Override
            public String getKey(Attribute object) {
                return object.getName();
            }
        };
        this.connection = conn;
        ArrayList<E> combinedList = new ArrayList<E>();
        combinedList.addAll(coreAttributes);
        combinedList.addAll(extendedAttributes);
        this.addAdditionalValidators(combinedList, contractFieldPath, attrKeyGetter);
        if (this.isIncludeCoreAttributeNameFormat(conn)) {
            i = 0;
            String coreAttrPath = ConnectionPaths.getCoreAttributes(contractFieldPath);
            for (Attribute attr : coreAttributes) {
                if (attr != null) {
                    this.createAttributeValidator(attr, coreAttrPath, i);
                }
                ++i;
            }
        }
        if (this.isIncludeExtendedAttributeNameFormat(conn)) {
            i = 0;
            String extAttrPath = ConnectionPaths.getExtendedAttributesPath(contractFieldPath);
            for (Attribute attr : extendedAttributes) {
                if (attr != null) {
                    this.createAttributeValidator(attr, extAttrPath, i);
                }
                ++i;
            }
        }
    }

    protected boolean isIncludeExtendedAttributeNameFormat(SpConnection spConn) {
        Protocol protocol = spConn.getSpBrowserSso().getProtocol();
        return protocol == Protocol.SAML20 || protocol == Protocol.SAML11 || protocol == Protocol.WSFED && spConn.getSpBrowserSso().getWsFedTokenType() == WsFedTokenType.SAML11;
    }

    protected boolean isIncludeCoreAttributeNameFormat(SpConnection spConn) {
        Protocol protocol = spConn.getSpBrowserSso().getProtocol();
        return protocol != Protocol.WSFED;
    }

    private void addAttrValidators(List<E> attributes, String contractFieldPath, UniqueEntriesValidator.UniqueKeyGetter<E> attrKeyGetter) {
        if (attributes == null) {
            return;
        }
        int i = 0;
        for (Attribute attr : attributes) {
            if (attr != null) {
                this.createAttributeValidator(attr, contractFieldPath, i);
            }
            ++i;
        }
    }

    public void addAdditionalValidators(List<E> attributes, String contractFieldPath, UniqueEntriesValidator.UniqueKeyGetter<E> attrKeyGetter) {
        this.addValidator((Validator)new UniqueEntriesValidator<E>(attrKeyGetter, attributes, contractFieldPath, ApiMessageKey.attribute_contract_duplicate_entry, ApiMessageKey.attribute_contract_empty));
    }

    public void createAttributeValidator(E attr, String contractFieldPath, int i) {
        this.addValidator((Validator)new NotBlankValidator(((Attribute)attr).getName(), "name", ConnectionPaths.getAttributeContractAttributeName(contractFieldPath, i)));
    }
}

