/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.validator.NameFormatValidator;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml1x.profiles.ap.CreateResponse;

public class AttributeNameFormatValidator
extends NameFormatValidator {
    private Protocol protocol;

    public AttributeNameFormatValidator(String nameFormat, String contractFieldPath, int index, Protocol protocol) {
        super(nameFormat, contractFieldPath, index);
        this.protocol = protocol;
        ConfigStore customNameFormatConfigStore = ConfigStoreFarm.getConfig((String)"custom-name-formats");
        if (protocol == Protocol.SAML20) {
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        } else if (protocol == Protocol.WSFED) {
            this.validFormats.add("http://schemas.xmlsoap.org/claims");
            Map stsAttributeNamespaces = customNameFormatConfigStore.getMapValue("sts-attribute-namespaces", Collections.EMPTY_MAP);
            for (Object key : stsAttributeNamespaces.keySet()) {
                this.validFormats.add((String)stsAttributeNamespaces.get(key));
            }
        } else if (Protocol.isSaml1x(protocol)) {
            ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);
            String ns = createResponseConfig.getStringValue("ns", "ns:unspecified");
            this.validFormats.add(ns);
        }
        Map customAttributeNameFormats = customNameFormatConfigStore.getMapValue("attribute-name-formats", Collections.EMPTY_MAP);
        for (Object key : customAttributeNameFormats.keySet()) {
            this.validFormats.add((String)customAttributeNameFormats.get(key));
        }
    }

    @Override
    public boolean validate() {
        if (Protocol.isSaml1x(this.protocol) && StringUtils.isEmpty((String)this.nameFormat)) {
            return true;
        }
        return super.validate();
    }
}

