/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.CustomAttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.JdbcAttributeSource;
import com.pingidentity.admin.api.model.LdapAttributeSource;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.CustomAttributeSourceFilterValidator;
import com.pingidentity.admin.api.validator.JdbcColumnNamesValidator;
import com.pingidentity.admin.api.validator.JdbcFilterValidator;
import com.pingidentity.admin.api.validator.JdbcTableValidator;
import com.pingidentity.admin.api.validator.LdapAttributesValidator;
import com.pingidentity.admin.api.validator.LdapNameValidator;
import com.pingidentity.admin.api.validator.LdapSearchFilterValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.Collections;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AttributeSourceValidator
extends CompositeValidator {
    private final AttributeSource source;
    private final String attributeSourcePath;
    private final boolean isExpressProvisioning;
    private Collection<String> coreSourceSubstitutionVars = Collections.emptyList();
    private String coreSourceName = "";
    private boolean skipValidateVars;
    private ValidatorContext context;

    public AttributeSourceValidator(AttributeSource source, String attributeSourcePath) {
        this(source, false, attributeSourcePath, null);
    }

    public AttributeSourceValidator(AttributeSource source, boolean isExpressProvisioning, String attributeSourcePath, ValidatorContext context) {
        this.source = source;
        this.isExpressProvisioning = isExpressProvisioning;
        this.attributeSourcePath = attributeSourcePath;
        this.context = context;
        this.addValidator((Validator)new ResourceIdValidator(source.getDataStoreRef(), "Data Store reference id", ConnectionPaths.getAttributeSourceDataStoreLinkPath(attributeSourcePath)));
    }

    @Override
    public boolean validate() {
        boolean isValid = super.validate();
        if (this.source != null && this.source.getId() != null && !ValidationUtil.isAlphaNumeric((String)this.source.getId())) {
            isValid = false;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_source_id_must_be_alphanumeric, ConnectionPaths.getAttributeSourceIdPath(this.attributeSourcePath), new Object[]{this.source.getId()}));
        }
        if (this.source != null && this.source.getType() == null) {
            isValid = false;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_source_data_type_not_recognized, ConnectionPaths.getAttributeSourceDataStoreTypePath(this.attributeSourcePath)));
        }
        if (isValid) {
            String dataStoreId = this.source.getDataStoreRef().getId();
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            if (this.source.getType() == DataStoreType.CUSTOM) {
                CustomAttributeSource customSource = (CustomAttributeSource)this.source;
                if (dsMgr.getCustomDataSource(dataStoreId) != null) {
                    this.runValidator((Validator)new CustomAttributeSourceFilterValidator(customSource.getFilterFields(), dataStoreId, ConnectionPaths.getAttributeSourceCustomDSFilterPath(this.attributeSourcePath)));
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, ConnectionPaths.getAttributeSourceDataStoreLinkIdPath(this.attributeSourcePath), new Object[]{dataStoreId}));
                }
            } else if (this.source.getType() == DataStoreType.LDAP) {
                LdapDataSource ldapDataSource = dsMgr.getLdapDataSource(dataStoreId);
                if (ldapDataSource != null) {
                    LdapAttributeSource ldapSource = (LdapAttributeSource)this.source;
                    if (!this.isBypassExternalValidation()) {
                        this.runValidator((Validator)new LdapNameValidator(ldapSource.getBaseDn(), this.getCoreSourceSubstitutionVars(), ApiMessageKey.ldap_attribute_source_base_dn_malformed, ApiMessageKey.ldap_attribute_source_base_dn_var_not_found, ConnectionPaths.getAttributeSourceLdapDSBaseDnPath(this.attributeSourcePath)));
                    }
                    if (ldapSource.getSearchScope() == null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_attribute_source_search_scope_required, ConnectionPaths.getAttributeSourceLdapDSSearchScopePath(this.attributeSourcePath)));
                    } else {
                        LdapSearchFilterValidator validator = null;
                        validator = this.skipValidateVars ? new LdapSearchFilterValidator(ldapSource.getSearchFilter(), ApiMessageKey.ldap_attribute_source_search_filter_required, ConnectionPaths.getAttributeSourceLdapDSSearchFilterPath(this.attributeSourcePath), ldapSource.getSearchScope().getId()) : new LdapSearchFilterValidator(ldapSource.getSearchFilter(), this.coreSourceSubstitutionVars, this.coreSourceName, ApiMessageKey.ldap_attribute_source_search_filter_required, ApiMessageKey.ldap_attribute_source_search_filter_var_not_found, ConnectionPaths.getAttributeSourceLdapDSSearchFilterPath(this.attributeSourcePath), ldapSource.getSearchScope().getId(), this.isBypassExternalValidation());
                        this.runValidator((Validator)validator);
                    }
                    if (ldapSource.getSearchAttributes() != null && !this.isBypassExternalValidation()) {
                        this.runValidator((Validator)new LdapAttributesValidator(ldapSource.getSearchAttributes(), ldapDataSource.getLDAPAttributeNameList(), ConnectionPaths.getAttributeSourceLdapDSSearchAttributesPath(this.attributeSourcePath)));
                    }
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, ConnectionPaths.getAttributeSourceDataStoreLinkIdPath(this.attributeSourcePath), new Object[]{dataStoreId}));
                }
            } else if (this.source.getType() == DataStoreType.JDBC) {
                JdbcDataSource jdbcDs = dsMgr.getJdbcDataSource(dataStoreId);
                if (jdbcDs != null) {
                    JdbcAttributeSource jdbcSource = (JdbcAttributeSource)this.source;
                    if (!this.isBypassExternalValidation()) {
                        this.runValidator((Validator)new JdbcTableValidator(jdbcSource.getSchema(), jdbcSource.getTable(), jdbcDs, this.isExpressProvisioning, this.attributeSourcePath));
                    }
                    JdbcFilterValidator jdbcValidator = null;
                    jdbcValidator = this.skipValidateVars ? new JdbcFilterValidator(jdbcSource.getFilter(), this.attributeSourcePath) : new JdbcFilterValidator(jdbcSource.getFilter(), this.coreSourceSubstitutionVars, this.coreSourceName, this.attributeSourcePath, this.isBypassExternalValidation());
                    this.runValidator((Validator)jdbcValidator);
                    if (jdbcSource.getColumnNames() != null && !this.isBypassExternalValidation()) {
                        this.runValidator((Validator)new JdbcColumnNamesValidator(jdbcSource.getColumnNames(), jdbcDs.getUnsortedColumns(jdbcSource.getSchema(), jdbcSource.getTable()), ConnectionPaths.getAttributeSourceJdbcDSColumnNamesPath(this.attributeSourcePath)));
                    }
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, ConnectionPaths.getAttributeSourceDataStoreLinkIdPath(this.attributeSourcePath), new Object[]{dataStoreId}));
                }
            }
        }
        return !this.hasErrors();
    }

    private boolean isBypassExternalValidation() {
        return this.context != null && this.context.isBypassExternalValidation();
    }

    private void runValidator(Validator validator) {
        validator.validate();
        this.appendErrors(validator.getErrors());
    }

    public Collection<String> getCoreSourceSubstitutionVars() {
        return this.coreSourceSubstitutionVars;
    }

    public void setCoreSourceSubstitutionVars(String coreSourceName, Collection<String> coreSourceSubstitutionVars) {
        this.coreSourceName = coreSourceName;
        this.coreSourceSubstitutionVars = coreSourceSubstitutionVars;
    }

    public AttributeSource getSource() {
        return this.source;
    }

    public void setSkipValidateVars(boolean validateVars) {
        this.skipValidateVars = validateVars;
    }
}

