/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ApcMappingPolicyAction;
import com.pingidentity.admin.api.model.AuthenticationPolicySelectionActionType;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.AuthnSelectorPolicyAction;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.ContinuePolicyAction;
import com.pingidentity.admin.api.model.DonePolicyAction;
import com.pingidentity.admin.api.model.FragmentPolicyAction;
import com.pingidentity.admin.api.model.LocalIdentityMappingPolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.RestartPolicyAction;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.ApcMappingActionValidator;
import com.pingidentity.admin.api.validator.AuthnSelectorActionValidator;
import com.pingidentity.admin.api.validator.AuthnSourceActionValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ContinueActionValidator;
import com.pingidentity.admin.api.validator.DoneActionValidator;
import com.pingidentity.admin.api.validator.FragmentActionValidator;
import com.pingidentity.admin.api.validator.LocalIdentityMappingActionValidator;
import com.pingidentity.admin.api.validator.RestartActionValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.admin.api.validator.structures.FragmentInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.common.util.AuthenticationPoliciesUtil;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.List;

public class AuthenticationPolicyActionValidator
extends CompositeValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private PolicyAction action;
    private String rootFieldPath = null;

    public AuthenticationPolicyActionValidator(C2cContractManager apcMgr, String rootFieldPath, PolicyAction action, List<AuthenticationPolicyTreeNode> children, PolicyAction parentNodeAction, boolean hasAuthnSourceAncestor, boolean hasSuccessInPath, UpstreamSources upstreamSources, boolean uniqueIdAttributeRequired, List<String> trackedParams, ValidatorContext context, FragmentInfo fragmentInfo) {
        this.action = action;
        this.rootFieldPath = rootFieldPath;
        AuthenticationPolicySelectionActionType type = action.getType();
        if (type != null) {
            ActionValidatorInfo.ActionValidatorInfoBuilder actionValidatorInfoBuilder = new ActionValidatorInfo.ActionValidatorInfoBuilder(rootFieldPath, action, children, parentNodeAction, hasAuthnSourceAncestor);
            actionValidatorInfoBuilder.setTrackedParams(trackedParams);
            actionValidatorInfoBuilder.setHasSuccessInPath(hasSuccessInPath);
            actionValidatorInfoBuilder.setUpstreamSources(upstreamSources);
            actionValidatorInfoBuilder.setFragmentInfo(fragmentInfo);
            switch (type) {
                case AUTHN_SELECTOR: {
                    if (!(action instanceof AuthnSelectorPolicyAction)) break;
                    this.addValidator((Validator)new AuthnSelectorActionValidator(actionValidatorInfoBuilder.build()));
                    break;
                }
                case AUTHN_SOURCE: {
                    if (!(action instanceof AuthnSourcePolicyAction)) break;
                    UpstreamSources inputUserIdSuccessfulSources = new UpstreamSources();
                    for (UpstreamSource successfulAuthnSource : upstreamSources.getSources()) {
                        if (!successfulAuthnSource.getType().equals((Object)UpstreamSource.UpstreamSourceType.IDP_ADAPTER) && !successfulAuthnSource.getType().equals((Object)UpstreamSource.UpstreamSourceType.FRAGMENT) && (!successfulAuthnSource.getType().equals((Object)UpstreamSource.UpstreamSourceType.IDP_CONNECTION) || !AuthenticationPoliciesUtil.isAllowInputUserIdMappingForIdpConnection((String)successfulAuthnSource.getId()))) continue;
                        inputUserIdSuccessfulSources.addSource(successfulAuthnSource);
                    }
                    actionValidatorInfoBuilder.setUpstreamSources(inputUserIdSuccessfulSources);
                    this.addValidator((Validator)new AuthnSourceActionValidator(actionValidatorInfoBuilder.build(), context));
                    break;
                }
                case APC_MAPPING: {
                    if (!(action instanceof ApcMappingPolicyAction)) break;
                    this.addValidator((Validator)new ApcMappingActionValidator(actionValidatorInfoBuilder.build(), apcMgr, context));
                    break;
                }
                case LOCAL_IDENTITY_MAPPING: {
                    if (!(action instanceof LocalIdentityMappingPolicyAction)) break;
                    this.addValidator((Validator)new LocalIdentityMappingActionValidator(actionValidatorInfoBuilder.build(), uniqueIdAttributeRequired, context));
                    break;
                }
                case CONTINUE: {
                    if (!(action instanceof ContinuePolicyAction)) break;
                    this.addValidator((Validator)new ContinueActionValidator(actionValidatorInfoBuilder.build()));
                    break;
                }
                case DONE: {
                    if (!(action instanceof DonePolicyAction)) break;
                    this.addValidator((Validator)new DoneActionValidator(actionValidatorInfoBuilder.build()));
                    break;
                }
                case RESTART: {
                    if (!(action instanceof RestartPolicyAction)) break;
                    this.addValidator((Validator)new RestartActionValidator(actionValidatorInfoBuilder.build()));
                    break;
                }
                case FRAGMENT: {
                    if (!(action instanceof FragmentPolicyAction)) break;
                    this.addValidator((Validator)new FragmentActionValidator(actionValidatorInfoBuilder.build(), context));
                    break;
                }
            }
        }
    }

    @Override
    public boolean validate() {
        AuthenticationPolicySelectionActionType type = this.action.getType();
        if (type == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_type_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getType())));
        }
        super.validate();
        return !this.hasErrors();
    }

    private String makeFieldPath(String suffix) {
        if (this.rootFieldPath == null) {
            return suffix;
        }
        return this.rootFieldPath + "." + suffix;
    }
}

