/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.AuthenticationPolicyContractAssertionMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.AuthenticationSourceMappingsValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.FailSafeAttributeValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyContractAssertionMappingsValidator
extends AuthenticationSourceMappingsValidator {
    private C2cContractManager contractManager = MgmtFactory.getC2cContractManager();

    public AuthenticationPolicyContractAssertionMappingsValidator(SpBrowserSso browserSso, C2cContractManager c2cContractManager) {
        this(browserSso, Collections.emptyList(), c2cContractManager, null);
    }

    public AuthenticationPolicyContractAssertionMappingsValidator(SpBrowserSso browserSso, List<String> availableVirtualServerIds, C2cContractManager c2cContractManager, ValidatorContext context) {
        super(browserSso, availableVirtualServerIds, context);
        this.contractManager = c2cContractManager;
        List<AuthenticationPolicyContractAssertionMapping> apiMappings = browserSso.getAuthenticationPolicyContractAssertionMappings();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), AuthenticationPolicyContractAssertionMappingsValidator.createTextValBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        if (ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyContractAssertionMapping> apcRefKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<AuthenticationPolicyContractAssertionMapping>(){

            @Override
            public String getKey(AuthenticationPolicyContractAssertionMapping object) {
                if (object.getAuthenticationPolicyContractRef() != null && object.getAuthenticationPolicyContractRef().getId() != null) {
                    return object.getAuthenticationPolicyContractRef().getId();
                }
                return null;
            }
        };
        this.addValidator((Validator)new UniqueEntriesValidator<AuthenticationPolicyContractAssertionMapping>(apcRefKeyGetter, apiMappings, ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(), ApiMessageKey.authentication_policy_contract_mappings_duplicate_mappings));
        int mappingIndex = 0;
        for (AuthenticationPolicyContractAssertionMapping apiMapping : apiMappings) {
            String contractId;
            String apcMappingPath = ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(mappingIndex);
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            validSources.putAll(rootSources);
            ExpressionManager expressionManager = ExpressionManager.getInstance();
            if (expressionManager.isEvaluateExpressionsOn()) {
                validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
            }
            HashSet apcContract = null;
            this.addValidator((Validator)new ResourceIdValidator(apiMapping.getAuthenticationPolicyContractRef(), "Authentication Policy Contract reference id", ConnectionPaths.getAuthenticationPolicyContractAssertionMappingApcLinkPath(mappingIndex)));
            if (apiMapping.getAuthenticationPolicyContractRef() != null && apiMapping.getAuthenticationPolicyContractRef().getId() != null && this.validateApcExists(contractId = apiMapping.getAuthenticationPolicyContractRef().getId(), apcMappingPath)) {
                C2cContract c2cContract = this.contractManager.getContract(contractId);
                apcContract = new HashSet();
                apcContract.addAll(c2cContract.getAllAttributeNames());
                AttributeSetSourceTypeValidatorBuilder attributeSourceTypeValidatorBuilder = new AttributeSetSourceTypeValidatorBuilder(c2cContract.getAllAttributeNames(), SourceType.AUTHENTICATION_POLICY_CONTRACT);
                validSources.put(new SourceTypeIdKey(SourceType.AUTHENTICATION_POLICY_CONTRACT), attributeSourceTypeValidatorBuilder);
                rootSources.put(new SourceTypeIdKey(SourceType.AUTHENTICATION_POLICY_CONTRACT), attributeSourceTypeValidatorBuilder);
            }
            AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = this.createAssertionValBuilder(browserSso);
            HashSet sourceSubstitutionAttrs = new HashSet();
            if (apcContract != null) {
                sourceSubstitutionAttrs.addAll(apcContract);
            }
            HashMap<String, HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>> validSourcesForAttributeSources = new HashMap<String, HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>>();
            for (AttributeSource source : apiMapping.getAttributeSources()) {
                HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> types = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                if (source == null || source.getAttributeContractFulfillment() == null) continue;
                types.putAll(rootSources);
                this.mapDataStoreTypeToDsValidator(source, types);
                validSourcesForAttributeSources.put(source.getDataStoreRef().getId(), types);
            }
            if (!this.isSourceContainsFulfillment(apiMapping.getAttributeSources())) {
                this.mapDataStoreTypesToDsValidators(apiMapping, validSources);
            }
            this.addValidator((Validator)new AttributeMappingValidator(apiMapping, assertionSourceTypeBuilder.getAssertionAttributes(), sourceSubstitutionAttrs, "assertion", validSources, validSourcesForAttributeSources, apcMappingPath, this.getContext()){

                @Override
                public boolean doValidateAttrSourceId(AttributeMapping apiMapping) {
                    return apiMapping.getAttributeSources().size() > 1 && !AuthenticationPolicyContractAssertionMappingsValidator.this.isSourceContainsFulfillment(apiMapping.getAttributeSources());
                }
            });
            this.validateAttrSourceAttrContractFulfillments(apiMapping.getAttributeSources(), apcMappingPath);
            if (apiMapping.isAbortSsoTransactionAsFailSafe()) {
                this.addValidator((Validator)new FailSafeAttributeValidator(apiMapping.isAbortSsoTransactionAsFailSafe(), apiMapping.getAttributeSources(), apiMapping.getIssuanceCriteria(), apiMapping.getAttributeContractFulfillment(), ConnectionPaths.getAuthenticationPolicyContractAssertionMappingAbortSsoPath(mappingIndex)));
            }
            ++mappingIndex;
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        return this.validateAuthenticationPolicyContractAssertionMapping();
    }

    boolean validateAuthenticationPolicyContractAssertionMapping() {
        boolean noVsidErrorFound = false;
        int mappingIndex = 0;
        for (AuthenticationPolicyContractAssertionMapping authenticationPolicyContractAssertionMapping : this.browserSso.getAuthenticationPolicyContractAssertionMappings()) {
            int vsidIndex = 0;
            if (authenticationPolicyContractAssertionMapping.isRestrictVirtualEntityIds() && this.availableVirtualServerIds.isEmpty() && !noVsidErrorFound) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_not_required, ConnectionPaths.getAuthenticationPolicyContractAssertionMappingRestrictedVirtualEntityIdPath(mappingIndex)));
                noVsidErrorFound = true;
            } else if (!authenticationPolicyContractAssertionMapping.isRestrictVirtualEntityIds() && !authenticationPolicyContractAssertionMapping.getRestrictedVirtualEntityIds().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_ids_not_allowed, ConnectionPaths.getAuthenticationPolicyContractAssertionMappingRestrictedVirtualEntityIdPath(mappingIndex)));
            } else {
                ArrayList<String> seenEntityIds = new ArrayList<String>(authenticationPolicyContractAssertionMapping.getRestrictedVirtualEntityIds().size());
                for (String virtualEntityId : authenticationPolicyContractAssertionMapping.getRestrictedVirtualEntityIds()) {
                    String virtualEntityPath = ConnectionPaths.getAuthenticationPolicyContractAssertionMappingRestrictedVirtualEntityIdPath(mappingIndex, vsidIndex);
                    if (seenEntityIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_duplicate, virtualEntityPath, new Object[]{virtualEntityId}));
                    } else if (!this.availableVirtualServerIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_value_invalid_virtual_entity_id, virtualEntityPath, new Object[]{virtualEntityId}));
                    }
                    seenEntityIds.add(virtualEntityId);
                }
            }
            if (!authenticationPolicyContractAssertionMapping.isAbortSsoTransactionAsFailSafe()) {
                SpBrowserSsoAttributeContract attributeContract = this.browserSso.getAttributeContract();
                Map<String, AttributeFulfillmentValue> attributeContractFulfillment = authenticationPolicyContractAssertionMapping.getAttributeContractFulfillment();
                this.validateContractFulfillmentWhenContractExists(mappingIndex, attributeContract, attributeContractFulfillment);
            }
            ++mappingIndex;
        }
        return !this.hasErrors();
    }

    @Override
    protected ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForSpBrowserSSOWithC2cContracts());
        return builder;
    }

    private boolean validateApcExists(String apcId, String fieldPath) {
        C2cContract c2cContract = this.contractManager.getContract(apcId);
        if (c2cContract == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_not_found, ConnectionPaths.getResourceIdIdPath(fieldPath), new Object[]{apcId}));
        }
        return c2cContract != null;
    }

    private void validateContractFulfillmentWhenContractExists(int mappingIndex, SpBrowserSsoAttributeContract attributeContract, Map<String, AttributeFulfillmentValue> attributeContractFulfillment) {
        if (attributeContract != null && !attributeContract.isEmpty() && (attributeContractFulfillment == null || attributeContractFulfillment.isEmpty())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_attribute_contract_must_be_fulfilled, ConnectionPaths.getAuthenticationPolicyContractContractFulfillmentPath(mappingIndex)));
        }
    }
}

