/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeRule;
import com.pingidentity.admin.api.model.AttributeRules;
import com.pingidentity.admin.api.model.AuthenticationPolicySelectionActionType;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.AuthenticationSourceType;
import com.pingidentity.admin.api.model.AuthnSelectorPolicyAction;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.FragmentPolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyTreeNodePaths;
import com.pingidentity.admin.api.validator.AuthenticationPolicyActionValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.FragmentInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyTreeNodeValidator
extends CompositeValidator {
    protected ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private PolicyAction action;
    private List<AuthenticationPolicyTreeNode> children;
    private String rootFieldPath = null;
    private AuthnSelectorManager authnSelectorManager = MgmtFactory.getAuthnSelectorManager();

    public AuthenticationPolicyTreeNodeValidator(String rootFieldPath, AuthenticationPolicyTreeNode treeNode, PolicyAction parentNodeAction, boolean hasAuthnSourceAncestor, boolean hasSuccessInPath, UpstreamSources upstreamSources, boolean uniqueIdAttributeRequired, List<String> trackedParams, ValidatorContext context, FragmentInfo fragmentInfo) {
        this.action = treeNode.getAction();
        this.children = treeNode.getChildren();
        this.rootFieldPath = rootFieldPath;
        if (this.action != null) {
            C2cContractManager apcMgr = MgmtFactory.getC2cContractManager();
            UpstreamSources updatedUpstreamSources = this.updateSuccessfulAuthnSourcesList(parentNodeAction, this.action, upstreamSources);
            if (!hasSuccessInPath) {
                hasSuccessInPath = !updatedUpstreamSources.isEmpty();
            }
            this.addValidator((Validator)new AuthenticationPolicyActionValidator(apcMgr, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getAction()), this.action, this.children, parentNodeAction, hasAuthnSourceAncestor, hasSuccessInPath, updatedUpstreamSources, uniqueIdAttributeRequired, trackedParams, context, fragmentInfo));
            if (!hasAuthnSourceAncestor) {
                hasAuthnSourceAncestor = this.isAuthnSourceType();
            }
            if (this.children != null && !this.children.isEmpty()) {
                int index = 0;
                for (AuthenticationPolicyTreeNode childNode : this.children) {
                    boolean tempUniqueIdAttributeRequired = uniqueIdAttributeRequired;
                    if (uniqueIdAttributeRequired && this.containsRegistrationRule(this.action)) {
                        String registrationRuleResultValue = this.getRegistrationRuleResultValue(this.action);
                        tempUniqueIdAttributeRequired = !childNode.getAction().getContext().equals(registrationRuleResultValue);
                    }
                    String path = this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getChildren(index));
                    this.addValidator((Validator)new AuthenticationPolicyTreeNodeValidator(path, childNode, this.action, hasAuthnSourceAncestor, hasSuccessInPath, updatedUpstreamSources, tempUniqueIdAttributeRequired, trackedParams, context, fragmentInfo));
                    ++index;
                }
            }
        }
    }

    private boolean containsRegistrationRule(PolicyAction action) {
        AttributeRules attributeRules;
        if (action != null && action instanceof AuthnSourcePolicyAction && (attributeRules = ((AuthnSourcePolicyAction)action).getAttributeRules()) != null && attributeRules.getItems() != null) {
            Predicate<AttributeRule> isRegistrationRule = attributeRule -> StringUtils.isNotBlank((String)attributeRule.getAttributeName()) && attributeRule.getAttributeName().equals("policy.action") && StringUtils.isNotBlank((String)attributeRule.getExpectedValue()) && attributeRule.getExpectedValue().equals("identity.registration");
            return attributeRules.getItems().stream().anyMatch(isRegistrationRule);
        }
        return false;
    }

    private String getRegistrationRuleResultValue(PolicyAction action) {
        AttributeRules attributeRules;
        if (action != null && action instanceof AuthnSourcePolicyAction && (attributeRules = ((AuthnSourcePolicyAction)action).getAttributeRules()) != null && attributeRules.getItems() != null) {
            Predicate<AttributeRule> isRegistrationRule = attributeRule -> StringUtils.isNotBlank((String)attributeRule.getAttributeName()) && attributeRule.getAttributeName().equals("policy.action") && StringUtils.isNotBlank((String)attributeRule.getExpectedValue()) && attributeRule.getExpectedValue().equals("identity.registration");
            return attributeRules.getItems().stream().filter(isRegistrationRule).map(AttributeRule::getResult).findFirst().orElse("");
        }
        return "";
    }

    private UpstreamSources updateSuccessfulAuthnSourcesList(PolicyAction parentNodeAction, PolicyAction currentAction, UpstreamSources successfulAuthnSources) {
        if (this.action.getContext() != null && !this.action.getContext().equals("Fail")) {
            FragmentPolicyAction parentSourceAction;
            ResourceLink parentActionAuthnSource;
            if (parentNodeAction instanceof AuthnSourcePolicyAction) {
                AuthenticationSource parentActionAuthnSource2;
                AuthnSourcePolicyAction parentSourceAction2 = (AuthnSourcePolicyAction)parentNodeAction;
                if (!this.isCurrentActionFromPolicyActionRule(parentSourceAction2, currentAction) && (parentActionAuthnSource2 = parentSourceAction2.getAuthenticationSource()) != null && parentActionAuthnSource2.getType() != null && parentActionAuthnSource2.getSourceRef() != null && parentActionAuthnSource2.getSourceRef().getId() != null && (parentActionAuthnSource2.getType().equals((Object)AuthenticationSourceType.IDP_CONNECTION) || parentActionAuthnSource2.getType().equals((Object)AuthenticationSourceType.IDP_ADAPTER))) {
                    successfulAuthnSources.addSource(parentActionAuthnSource2);
                }
            } else if (parentNodeAction instanceof FragmentPolicyAction && (parentActionAuthnSource = (parentSourceAction = (FragmentPolicyAction)parentNodeAction).getFragment()) != null && parentActionAuthnSource.getId() != null) {
                successfulAuthnSources.addSource(parentActionAuthnSource.getId());
            }
        }
        return new UpstreamSources(successfulAuthnSources);
    }

    private boolean isCurrentActionFromPolicyActionRule(AuthnSourcePolicyAction parent, PolicyAction current) {
        AttributeRules attributeRules = parent.getAttributeRules();
        if (attributeRules == null) {
            return false;
        }
        List<AttributeRule> ruleItems = attributeRules.getItems();
        if (ruleItems == null) {
            return false;
        }
        AttributeRule matchingRule = ruleItems.stream().filter(rule -> rule.getResult() != null && rule.getResult().equals(current.getContext())).findFirst().orElse(null);
        if (matchingRule == null) {
            return false;
        }
        return "policy.action".equals(matchingRule.getAttributeName());
    }

    private boolean isAuthnSourceType() {
        boolean isAuthnSourceType = this.action.getType().equals((Object)AuthenticationPolicySelectionActionType.AUTHN_SOURCE) || this.action.getType().equals((Object)AuthenticationPolicySelectionActionType.FRAGMENT);
        boolean isAuthnSelectorProvidingAuthSource = this.isAuthnSelectorProvidingAuthSource();
        return isAuthnSourceType || isAuthnSelectorProvidingAuthSource;
    }

    private boolean isAuthnSelectorProvidingAuthSource() {
        String authnSelectorId;
        AuthnSelectorInstance instance;
        AuthnSelectorPolicyAction authnSelectorPolicyAction;
        if (this.action.getType() == AuthenticationPolicySelectionActionType.AUTHN_SELECTOR && this.action instanceof AuthnSelectorPolicyAction && (authnSelectorPolicyAction = (AuthnSelectorPolicyAction)this.action).getAuthenticationSelectorRef() != null && (instance = (AuthnSelectorInstance)this.authnSelectorManager.getInstance(authnSelectorId = authnSelectorPolicyAction.getAuthenticationSelectorRef().getId())) != null && instance.getId().equals(authnSelectorId) && instance.getDescriptor() != null && instance.getDescriptor() instanceof AuthenticationSelectorDescriptor) {
            AuthenticationSelectorDescriptor descriptor = (AuthenticationSelectorDescriptor)instance.getDescriptor();
            return descriptor.canSelectAuthnSourceResultType();
        }
        return false;
    }

    @Override
    public boolean validate() {
        if (this.action == null) {
            if (this.children == null || this.children.isEmpty()) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_node_empty, this.rootFieldPath));
            }
            if (this.children != null && !this.children.isEmpty()) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_action_required_when_children_present, this.makeFieldPath(AuthenticationPolicyTreeNodePaths.getAction())));
            }
        }
        if (this.hasErrors()) {
            return false;
        }
        super.validate();
        return !this.hasErrors();
    }

    private String makeFieldPath(String suffix) {
        if (this.rootFieldPath == null) {
            return suffix;
        }
        return this.rootFieldPath + "." + suffix;
    }
}

