/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationPolicyTree;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyPaths;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyTreePaths;
import com.pingidentity.admin.api.validator.AuthenticationPolicyTreeNodeValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.List;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyTreeValidator
extends CompositeValidator {
    private final ResourceLink overrideAuthenticationApiApplication;
    protected ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private AuthenticationPolicyTreeNode rootNode;
    private String rootFieldPath = null;

    public AuthenticationPolicyTreeValidator(String rootFieldPath, AuthenticationPolicyTree tree, List<String> trackedParams, ValidatorContext context) {
        this.rootNode = tree.getRootNode();
        this.rootFieldPath = rootFieldPath;
        this.overrideAuthenticationApiApplication = tree.getAuthenticationApiApplicationRef();
        if (this.rootNode != null) {
            String path = this.makeFieldPath(AuthenticationPolicyTreePaths.getRootNode());
            this.addValidator((Validator)new AuthenticationPolicyTreeNodeValidator(path, this.rootNode, null, false, false, new UpstreamSources(), true, trackedParams, context, null));
        }
        this.addValidator((Validator)new IdValidator(tree.getId(), true, false, 0, 33, this.makeFieldPath(AuthenticationPolicyPaths.getId())));
    }

    @Override
    public boolean validate() {
        AuthnApiApplication app;
        super.validate();
        if (this.rootNode == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_node_empty, this.makeFieldPath(AuthenticationPolicyTreePaths.getRootNode())));
        }
        if (this.overrideAuthenticationApiApplication != null && (app = MgmtFactory.getAuthnApiManager().getApiApplication(this.overrideAuthenticationApiApplication.getId())) == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_authn_api_application_invalid, null));
        }
        return !this.hasErrors();
    }

    private String makeFieldPath(String suffix) {
        if (this.rootFieldPath == null) {
            return suffix;
        }
        return this.rootFieldPath + "." + suffix;
    }
}

