/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthnContextMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.Iterator;
import java.util.List;

public class AuthnContextMappingValidator
extends CompositeValidator {
    private List<AuthnContextMapping> authnContextMappings;
    private Protocol protocol;

    public AuthnContextMappingValidator(List<AuthnContextMapping> authnContextMap, Protocol connectionProtocol) {
        this.authnContextMappings = authnContextMap;
        this.protocol = connectionProtocol;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.authnContextMappings != null && this.protocol != null) {
            if (!this.protocol.equals((Object)Protocol.SAML20) && this.protocol != Protocol.OIDC) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_not_supported, ConnectionPaths.getAuthnContext(), new Object[]{this.protocol}));
                return false;
            }
            int i = 0;
            for (AuthnContextMapping authnContextMap : this.authnContextMappings) {
                String remoteValue;
                String localValue = authnContextMap.getLocal();
                if (localValue.equals(remoteValue = authnContextMap.getRemote())) {
                    if (localValue.equals("")) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_local_remote_empty, ConnectionPaths.getAuthnContext(i)));
                    } else {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_local_equals_remote, ConnectionPaths.getAuthnContext(i)));
                    }
                }
                this.handleAsterisk(localValue, ConnectionPaths.getAuthnContextLocalValue(i));
                this.handleAsterisk(remoteValue, ConnectionPaths.getAuthnContextRemoteValue(i));
                Iterator<AuthnContextMapping> compare = this.authnContextMappings.iterator();
                for (int j = 0; compare.hasNext() && j < i; ++j) {
                    AuthnContextMapping compareMapping = compare.next();
                    String localCompare = compareMapping.getLocal();
                    String remoteCompare = compareMapping.getRemote();
                    this.handleDuplicateValues(localValue, remoteValue, localCompare, remoteCompare, ConnectionPaths.getAuthnContextLocalValue(i), false);
                    this.handleDuplicateValues(remoteValue, localValue, remoteCompare, localCompare, ConnectionPaths.getAuthnContextRemoteValue(i), true);
                }
                ++i;
            }
        }
        boolean isValid = !this.hasErrors();
        return isValid;
    }

    private void handleDuplicateValues(String localValue, String remoteValue, String localCopy, String remoteCopy, String errorPath, boolean isLocal) {
        String current = "local";
        String other = "remote";
        if (isLocal) {
            current = "remote";
            other = "local";
        }
        if (localCopy.equals(localValue)) {
            if (remoteValue.equals(remoteCopy)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_duplicate_value, errorPath, new Object[]{current, localValue, other}));
            } else if (!remoteValue.equals("*") && !remoteCopy.equals("*")) {
                if (localCopy.equals("")) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_duplicate_empty_space, errorPath, new Object[]{current, other}));
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_duplicate_non_asterisk, errorPath, new Object[]{current, localValue, other}));
                }
            }
        }
    }

    private void handleAsterisk(String value, String errorPath) {
        if (value.contains("*") && value.length() > 1) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authn_context_mapping_invalid_asterisk, errorPath));
        }
    }
}

