/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.access.ExtendedPropertyAccessor;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.LocalIdentityMappingPolicyAction;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.InputContractSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TrackedParametersSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthnPolicyLipAttributeMappingValidator
extends BaseAttributeDataSourceValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final ActionValidatorInfo validatorInfo;
    private LocalIdentityProfile domainLip;
    private AttributeMapping inboundMapping;
    private AttributeMapping outboundMapping;
    private boolean uniqueIdAttributeRequired;
    private C2cContractManager c2cContractMgr = MgmtFactory.getC2cContractManager();

    public AuthnPolicyLipAttributeMappingValidator(LocalIdentityMappingPolicyAction localIdentityMappingPolicyAction, LocalIdentityProfile domainLocalIdentityProfile, ActionValidatorInfo validatorInfo, boolean uniqueIdAttributeRequired, ValidatorContext context) {
        super(context);
        this.domainLip = domainLocalIdentityProfile;
        this.validatorInfo = validatorInfo;
        this.outboundMapping = localIdentityMappingPolicyAction.getOutboundAttributeMapping();
        this.inboundMapping = localIdentityMappingPolicyAction.getInboundMapping();
        this.uniqueIdAttributeRequired = uniqueIdAttributeRequired;
    }

    @Override
    public boolean validate() {
        if (this.domainLip.isRegistrationEnabled() || this.domainLip.isProfileEnabled()) {
            this.validateInboundMapping(this.uniqueIdAttributeRequired);
        }
        this.validateOutboundMapping();
        return super.validate();
    }

    private void validateInboundMapping(boolean uniqueIdAttributeRequired) {
        if ((this.domainLip.isRegistrationEnabled() || this.domainLip.isProfileEnabled()) && this.inboundMapping == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_local_identity_profile_inbound_mapping_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getInboundMapping())));
            return;
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        HashSet<String> substitutionVars = new HashSet<String>();
        this.populateGeneralValidSources(validSources, substitutionVars, true);
        int index = 0;
        for (AttributeSource attributeSource : this.inboundMapping.getAttributeSources()) {
            String attribute_source_id = "Attribute Source ID";
            this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), attribute_source_id, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeSourceId(index))));
            ++index;
        }
        this.mapDataStoreTypesToDsValidators(this.inboundMapping, validSources);
        Set<String> validFieldNames = this.getAllFieldNames();
        if (uniqueIdAttributeRequired) {
            validFieldNames.add("pf.local.identity.unique.id");
        }
        String lip_inbound_mapping = "lip inbound mapping";
        this.addValidator((Validator)new AttributeMappingValidator(this.inboundMapping, validFieldNames, substitutionVars, lip_inbound_mapping, validSources, true, this.makeFieldPath(AuthenticationPolicyActionPaths.getInboundMapping()), this.getContext()));
        if (uniqueIdAttributeRequired && !this.inboundMapping.getAttributeContractFulfillment().containsKey("pf.local.identity.unique.id")) {
            this.appendError(this.errorFactory.create(ApiMessageKey.attribute_mapping_missing_attribute, this.makeFieldPath(AuthenticationPolicyActionPaths.getInboundMapping()), new Object[]{"pf.local.identity.unique.id"}));
        }
    }

    private void validateOutboundMapping() {
        if (this.outboundMapping == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_local_identity_profile_outbound_mapping_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeMapping())));
            return;
        }
        C2cContract c2cContract = this.c2cContractMgr.getContract(this.domainLip.getContractId());
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        HashSet<String> substitutionVars = new HashSet<String>();
        this.populateGeneralValidSources(validSources, substitutionVars, false);
        String attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.LOCAL_IDENTITY_PROFILE, (String)this.domainLip.getId());
        AttributeSetSourceTypeValidatorBuilder lipAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(this.getAllFieldNames(), SourceType.LOCAL_IDENTITY_PROFILE, attrSrcKey);
        substitutionVars.addAll(lipAttributeBuilder.getExposedSubstitutionVariables());
        validSources.put(new SourceTypeIdKey(SourceType.LOCAL_IDENTITY_PROFILE, this.domainLip.getId()), lipAttributeBuilder);
        int index = 0;
        for (AttributeSource attributeSource : this.outboundMapping.getAttributeSources()) {
            this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", this.makeFieldPath(AuthenticationPolicyActionPaths.getAttributeSourceId(index))));
            ++index;
        }
        this.mapDataStoreTypesToDsValidators(this.outboundMapping, validSources);
        this.addValidator((Validator)new AttributeMappingValidator(this.outboundMapping, c2cContract.getAllAttributeNames(), substitutionVars, "lip outbound mapping", validSources, this.makeFieldPath(AuthenticationPolicyActionPaths.getOutboundAttributeMapping()), this.getContext()));
    }

    protected String makeFieldPath(String suffix) {
        if (this.validatorInfo.getRootFieldPath() == null) {
            return suffix;
        }
        return this.validatorInfo.getRootFieldPath() + "." + suffix;
    }

    private void populateGeneralValidSources(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, Set<String> substitutionVars, boolean isInboundMapping) {
        Map extendedPropertyMap;
        ExpressionManager expressionManager;
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        if (!isInboundMapping) {
            ContextSourceTypeValidatorBuilder contextSourceTypeValidatorBuilder = this.createAuthnPolicyContextTypeBuilder();
            rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT, "context"), contextSourceTypeValidatorBuilder);
            substitutionVars.addAll(contextSourceTypeValidatorBuilder.getExposedSubstitutionVariables());
        }
        if ((expressionManager = ExpressionManager.getInstance()).isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        if (this.validatorInfo.getTrackedParams() != null && !this.validatorInfo.getTrackedParams().isEmpty()) {
            TrackedParametersSourceTypeValidatorBuilder trackedParamsValidator = new TrackedParametersSourceTypeValidatorBuilder(this.validatorInfo.getTrackedParams());
            rootSources.put(new SourceTypeIdKey(SourceType.TRACKED_HTTP_PARAMS, "trackedparams"), trackedParamsValidator);
            substitutionVars.addAll(trackedParamsValidator.getExposedSubstitutionVariables());
        }
        if (this.validatorInfo.isFragmentPolicy() && this.validatorInfo.getFragmentInfo().getInputContract() != null) {
            InputContractSourceTypeValidatorBuilder inputAttributesValidator = new InputContractSourceTypeValidatorBuilder(this.validatorInfo.getFragmentInfo().getInputContract().getAllAttrNamesSorted());
            rootSources.put(new SourceTypeIdKey(SourceType.INPUTS, "inputs"), inputAttributesValidator);
            substitutionVars.addAll(inputAttributesValidator.getExposedSubstitutionVariables());
        }
        if (!(extendedPropertyMap = new ExtendedPropertyAccessor().getExtendedPropertyDefinitions()).isEmpty()) {
            ExtendedMetadataSourceTypeValidatorBuilder extendedPropertiesValidatorBuilder = new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES);
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES, "extproperties"), extendedPropertiesValidatorBuilder);
            substitutionVars.addAll(extendedPropertiesValidatorBuilder.getExposedSubstitutionVariables());
        }
        validSources.putAll(rootSources);
        for (UpstreamSource successfulAuthnSource : this.validatorInfo.getUpstreamSources().getSources()) {
            PolicyFragment fragment;
            IdpConnection conn;
            Set allAttributeNames;
            String attrSrcKey;
            IdpAuthnAdapterInstance sourceAdapter;
            if (successfulAuthnSource.getType() == UpstreamSource.UpstreamSourceType.IDP_ADAPTER && (sourceAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(successfulAuthnSource.getId())) != null) {
                attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.ADAPTER, (String)sourceAdapter.getId());
                allAttributeNames = sourceAdapter.getAttributeContract().getAllAttributeNames();
                AttributeSetSourceTypeValidatorBuilder adapterAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(allAttributeNames, SourceType.ADAPTER, attrSrcKey);
                substitutionVars.addAll(adapterAttributeBuilder.getExposedSubstitutionVariables());
                validSources.put(new SourceTypeIdKey(SourceType.ADAPTER, sourceAdapter.getId()), adapterAttributeBuilder);
            }
            if (successfulAuthnSource.getType() == UpstreamSource.UpstreamSourceType.IDP_CONNECTION && (conn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(successfulAuthnSource.getId(), false)) != null) {
                attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.IDP_CONNECTION, (String)conn.getEntityId());
                allAttributeNames = conn.getAttributeContract().getAllAttributeNames();
                AttributeSetSourceTypeValidatorBuilder idpConnAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(allAttributeNames, SourceType.IDP_CONNECTION, attrSrcKey);
                substitutionVars.addAll(idpConnAttributeBuilder.getExposedSubstitutionVariables());
                validSources.put(new SourceTypeIdKey(SourceType.IDP_CONNECTION, conn.getId()), idpConnAttributeBuilder);
            }
            if (successfulAuthnSource.getType() != UpstreamSource.UpstreamSourceType.FRAGMENT || (fragment = MgmtFactory.getPolicyFragmentManager().getFragment(successfulAuthnSource.getId())) == null) continue;
            attrSrcKey = org.sourceid.saml20.domain.AttributeMapping.createAttrSourceKey((org.sourceid.saml20.domain.SourceType)org.sourceid.saml20.domain.SourceType.FRAGMENT, (String)fragment.getId());
            allAttributeNames = fragment.getOutputContractAllAttributes();
            AttributeSetSourceTypeValidatorBuilder fragmentConnAttrBuilder = new AttributeSetSourceTypeValidatorBuilder(allAttributeNames, SourceType.FRAGMENT, attrSrcKey);
            substitutionVars.addAll(fragmentConnAttrBuilder.getExposedSubstitutionVariables());
            validSources.put(new SourceTypeIdKey(SourceType.FRAGMENT, fragment.getId()), fragmentConnAttrBuilder);
        }
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private Set<String> getAllFieldNames() {
        if (this.domainLip.getFieldConfig() == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(this.domainLip.getFieldConfig().getListOfFieldIds());
    }
}

