/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.AuthnSelectorPolicyAction;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.AbstractActionValidator;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import java.util.ArrayList;
import org.sourceid.saml20.domain.AuthnSelectorInstance;

public class AuthnSelectorActionValidator
extends AbstractActionValidator {
    public AuthnSelectorActionValidator(ActionValidatorInfo info) {
        super(info);
    }

    @Override
    public boolean validate() {
        super.validate();
        if (((AuthnSelectorPolicyAction)this.validatorInfo.getAction()).getAuthenticationSelectorRef() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_incomplete_missing_authn_selector_ref, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationSelectorRef())));
        } else {
            String selectorId = ((AuthnSelectorPolicyAction)this.validatorInfo.getAction()).getAuthenticationSelectorRef().getId();
            if (selectorId == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.authn_selector_id_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationSelectorRefId())));
            } else {
                AuthnSelectorInstance domainInstance = this.getDomainAuthnSelector(selectorId);
                if (domainInstance == null || !domainInstance.getId().equals(selectorId)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.authn_selector_id_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationSelectorRefId())));
                } else {
                    ArrayList selectorAttributes = new ArrayList();
                    selectorAttributes.addAll(domainInstance.getOrderedResults());
                    ArrayList<String> contextsInApi = new ArrayList<String>();
                    for (AuthenticationPolicyTreeNode child : this.validatorInfo.getChildren()) {
                        if (child.getAction() == null) continue;
                        contextsInApi.add(child.getAction().getContext());
                    }
                    for (String selectorAttribute : selectorAttributes) {
                        if (!contextsInApi.contains(selectorAttribute)) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_context_missing_for_authn_selector_configuration, this.makeFieldPath(AuthenticationPolicyActionPaths.getContext()), new Object[]{selectorAttribute}));
                            continue;
                        }
                        contextsInApi.remove(selectorAttribute);
                    }
                    for (String context : contextsInApi) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_tree_context_invalid_for_authn_selector_configuration, this.makeFieldPath(AuthenticationPolicyActionPaths.getContext()), new Object[]{context}));
                    }
                }
            }
        }
        return !this.hasErrors();
    }

    @Override
    protected boolean isActionAllowed() {
        return true;
    }

    @Override
    protected boolean needsChildren() {
        return true;
    }
}

