/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.AuthenticationSourceType;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.AbstractAuthnSourceActionValidator;
import com.pingidentity.admin.api.validator.AuthenticationSourceValidator;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.common.util.AuthenticationPoliciesUtil;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthnSourceActionValidator
extends AbstractAuthnSourceActionValidator {
    UpstreamSources successfulAuthnSources;

    public AuthnSourceActionValidator(ActionValidatorInfo info, ValidatorContext context) {
        super(info, context);
        this.successfulAuthnSources = info.getUpstreamSources();
        this.addValidator((Validator)new AuthenticationSourceValidator(this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationSource()), ((AuthnSourcePolicyAction)info.getAction()).getAuthenticationSource(), context));
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.validatorInfo.getChildren() != null) {
            this.checkFailSuccessContextsPresent();
        }
        if (((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAuthenticationSource() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_selection_action_incomplete_missing_authn_source, this.makeFieldPath(AuthenticationPolicyActionPaths.getAuthenticationSource())));
        }
        if (this.hasErrors()) {
            return false;
        }
        this.validateInputUserIdMapping();
        this.validateAttributeRules(((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAttributeRules());
        return !this.hasErrors();
    }

    private void validateInputUserIdMapping() {
        AttributeFulfillmentValue inputUserIdMapping = ((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getInputUserIdMapping();
        if (inputUserIdMapping == null) {
            if (this.isUserIdAuthenticated()) {
                this.appendError(this.errorFactory.create(ApiMessageKey.user_id_authenticated_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getUserIdAuthenticated()), new Object[]{AuthenticationPolicyActionPaths.getUserIdAuthenticated()}));
                return;
            }
        } else {
            AuthenticationSource authenticationSource = ((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAuthenticationSource();
            if (((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAuthenticationSource().getType().equals((Object)AuthenticationSourceType.IDP_CONNECTION)) {
                if (this.isUserIdAuthenticated()) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.user_id_authenticated_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getUserIdAuthenticated()), new Object[]{AuthenticationPolicyActionPaths.getUserIdAuthenticated()}));
                }
                if (!AuthenticationPoliciesUtil.isAllowInputUserIdMappingForIdpConnection((String)authenticationSource.getSourceRef().getId())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMapping())));
                    return;
                }
            }
            if (((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getAuthenticationSource().getType().equals((Object)AuthenticationSourceType.IDP_ADAPTER) && !AuthenticationPoliciesUtil.isAllowInputUserIdMappingForAdapter((String)authenticationSource.getSourceRef().getId(), (boolean)true)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMapping())));
                return;
            }
            SourceTypeIdKey source = inputUserIdMapping.getSource();
            if (source == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSource())));
            } else if (source.getType() == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_type_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSourceType())));
            } else if (inputUserIdMapping.getValue() == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_value_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingValue())));
            } else if (!this.validInputUserIdSourceType(source.getType())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_type_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSourceType()), new Object[]{source.getType()}));
            } else if (source.getId() == null && source.getType() != SourceType.CONTEXT) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_id_required, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSourceId())));
            } else if (!this.validInputUserIdSourceId(source)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_id_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSourceId()), new Object[]{source.getId()}));
            }
            if (this.hasErrors()) {
                return;
            }
            this.validateInputUserIdMappingValue(inputUserIdMapping, source);
        }
    }

    private boolean isUserIdAuthenticated() {
        Boolean isUserIdAuthenticated = ((AuthnSourcePolicyAction)this.validatorInfo.getAction()).getUserIdAuthenticated();
        return isUserIdAuthenticated != null && Boolean.TRUE.equals(isUserIdAuthenticated);
    }

    void validateInputUserIdMappingValue(AttributeFulfillmentValue inputUserIdMapping, SourceTypeIdKey source) {
        Set availableAttributeNames;
        if (source.getType() == SourceType.CONTEXT && !inputUserIdMapping.getValue().equals(SourceContextType.REQUESTED_USER.getId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_value_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingValue()), new Object[]{inputUserIdMapping.getValue()}));
        }
        if (source.getType() == SourceType.ADAPTER) {
            IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
            IdpAuthnAdapterInstance adapterInstance = (IdpAuthnAdapterInstance)idpAdapterManager.getInstance(source.getId());
            if (adapterInstance == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_not_found, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSource())));
            } else {
                Set adapterAttributeNames = adapterInstance.getAttributeContract().getAllAttributeNames();
                if (!adapterAttributeNames.contains(inputUserIdMapping.getValue())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_value_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingValue()), new Object[]{inputUserIdMapping.getValue()}));
                }
            }
        }
        if (source.getType() == SourceType.IDP_CONNECTION) {
            ConnectionManager connManager = MgmtFactory.getConnectionManager();
            IdpConnection idpConnection = connManager.getIdpConnectionBySystemId(source.getId());
            if (idpConnection == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_not_found, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSource())));
            } else {
                availableAttributeNames = idpConnection.getAttributeContract().getAllAttributeNames();
                if (!availableAttributeNames.contains(inputUserIdMapping.getValue())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_value_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingValue()), new Object[]{inputUserIdMapping.getValue()}));
                }
            }
        }
        if (source.getType() == SourceType.INPUTS) {
            C2cContract inputContract = this.validatorInfo.getFragmentInfo().getInputContract();
            if (inputContract == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_not_found, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingSource())));
            } else {
                Set availableAttributeNames2 = inputContract.getAllAttributeNames();
                if (!availableAttributeNames2.contains(inputUserIdMapping.getValue())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_value_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingValue()), new Object[]{inputUserIdMapping.getValue()}));
                }
            }
        }
        if (source.getType() == SourceType.FRAGMENT) {
            PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(source.getId());
            C2cContract outputContract = fragment.getOutputContract();
            if (outputContract != null) {
                availableAttributeNames = outputContract.getAllAttributeNames();
                if (!availableAttributeNames.contains(inputUserIdMapping.getValue())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_value_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMappingValue()), new Object[]{inputUserIdMapping.getValue()}));
                }
            } else {
                this.appendError(this.errorFactory.create(ApiMessageKey.input_user_id_mapping_source_fragment_invalid, this.makeFieldPath(AuthenticationPolicyActionPaths.getInputUserIdMapping()), new Object[]{source.getId()}));
            }
        }
    }

    private boolean validInputUserIdSourceId(SourceTypeIdKey source) {
        if (source.getType() == SourceType.CONTEXT) {
            return source.getId() == null;
        }
        if (source.getType() == SourceType.INPUTS) {
            return "Inputs".equals(source.getId()) || "inputs".equals(source.getId());
        }
        HashSet<String> validSourceIDs = new HashSet<String>();
        if (this.successfulAuthnSources != null && !this.successfulAuthnSources.isEmpty()) {
            for (UpstreamSource successfulAuthnSource : this.successfulAuthnSources.getSources()) {
                validSourceIDs.add(successfulAuthnSource.getId());
            }
        }
        return validSourceIDs.contains(source.getId());
    }

    private boolean validInputUserIdSourceType(SourceType type) {
        HashSet<SourceType> validSourceTypes = new HashSet<SourceType>();
        validSourceTypes.add(SourceType.CONTEXT);
        if (this.validatorInfo.isFragmentPolicy()) {
            validSourceTypes.add(SourceType.INPUTS);
        }
        if (this.successfulAuthnSources != null && !this.successfulAuthnSources.isEmpty()) {
            for (UpstreamSource successfulAuthnSource : this.successfulAuthnSources.getSources()) {
                validSourceTypes.add(this.toAuthnSourceType(successfulAuthnSource.getType()));
            }
        }
        return validSourceTypes.contains((Object)type);
    }

    private SourceType toAuthnSourceType(UpstreamSource.UpstreamSourceType type) {
        switch (type) {
            case IDP_ADAPTER: {
                return SourceType.ADAPTER;
            }
            case IDP_CONNECTION: {
                return SourceType.IDP_CONNECTION;
            }
            case FRAGMENT: {
                return SourceType.FRAGMENT;
            }
            case INPUTS: {
                return SourceType.INPUTS;
            }
        }
        throw new RuntimeException("Unexpected AuthenticationSourceType: " + type);
    }

    @Override
    protected boolean isActionAllowed() {
        return true;
    }

    @Override
    protected boolean needsChildren() {
        return true;
    }
}

