/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AuthorizationServerSettingsPaths;
import com.pingidentity.admin.api.model.oauth.AuthorizationServerSettings;
import com.pingidentity.admin.api.model.oauth.PersistentGrantAttribute;
import com.pingidentity.admin.api.model.oauth.PersistentGrantContract;
import com.pingidentity.admin.api.model.oauth.ScopeEntry;
import com.pingidentity.admin.api.model.oauth.ScopeGroupEntry;
import com.pingidentity.admin.api.validator.ClientSecretRetentionPeriodValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.OauthScopeValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.PersistentGrantContractValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.admin.api.validator.simple.RelativePathValidator;
import com.pingidentity.pf.common.api.model.oauth.GrantType;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.oauth.conf.xmlbinding.OAuthConfigDocument;
import org.sourceid.oauth.conf.xmlbinding.OAuthConfigType;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.RefreshTokenRollingIntervalHelper;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceMultipleStarImpl;

public class AuthorizationServerSettingsValidator
extends CompositeValidator {
    public static final int AUTHORIZATION_CODE_TIMEOUT_MIN_VALUE = 1;
    public static final int AUTHORIZATION_CODE_TIMEOUT_MAX_VALUE = 3600;
    public static final int AUTHORIZATION_CODE_ENTROPY_MIN_VALUE = 16;
    public static final int AUTHORIZATION_CODE_ENTROPY_MAX_VALUE = 256;
    public static final long PERSISTENT_GRANT_LIFETIME_MIN_VALUE = 1L;
    public static final long PERSISTENT_GRANT_LIFETIME_MAX_VALUE = 999L;
    public static final long PERSISTENT_GRANT_LIFETIME_INDEFINFITE_VALUE = -1L;
    public static final long PERSISTENT_GRANT_IDLE_TIMEOUT_MIN_VALUE = 1L;
    public static final long PERSISTENT_GRANT_IDLE_TIMEOUT_MAX_VALUE = 999L;
    public static final long PERSISTENT_GRANT_IDLE_TIMEOUT_INDEFINITE_VALUE = -1L;
    public static final int REFRESH_TOKEN_LENGTH_MIN_VALUE = 28;
    public static final int REFRESH_TOKEN_LENGTH_MAX_VALUE = 256;
    public static final long REFRESH_TOKEN_GRACE_PERIOD_MIN_VALUE = 0L;
    public static final long REFRESH_TOKEN_GRACE_PERIOD_MAX_VALUE = 86400L;
    public static final int PENDING_AUTHZ_TIMEOUT_MIN_VALUE = 1;
    public static final int PENDING_AUTHZ_TIMEOUT_MAX_VALUE = 3600;
    public static final int DEVICE_POLLING_INTERVAL_MIN_VALUE = 1;
    public static final int DEVICE_POLLING_INTERVAL_MAX_VALUE = 3600;
    private static final int JARM_LIFETIME_MIN_VALUE = 1;
    private static final int JARM_LIFETIME_MAX_VALUE = 3600;
    static final int DPOP_PROOF_LIFETIME_SECONDS_MIN_VALUE = 1;
    static final int DPOP_PROOF_LIFETIME_SECONDS_MAX_VALUE = 3600;
    static final int USER_CONSENT_LIFETIME_DAYS_MIN_VALUE = 1;
    static final int USER_CONSENT_LIFETIME_DAYS_MAX_VALUE = 999;
    static final int USER_CONSENT_LIFETIME_DAYS_INDEFINITE_VALUE = -1;
    private static final OAuthConfigType DEFAULT_CONFIG = OAuthConfigDocument.Factory.newInstance().addNewOAuthConfig();
    private final String DEFAULT_GLOBAL_PERSISTENT_GRANT_IDLE_TIMEOUT = String.valueOf(DEFAULT_CONFIG.getGlobalPersistentGrantIdleTimeout());
    private final String DEFAULT_GLOBAL_PERSISTENT_GRANT_IDLE_TIMEOUT_UNIT = DEFAULT_CONFIG.getGlobalPersistentGrantIdleTimeoutTimeUnit();
    private String authCodeTimeout;
    private String authCodeEntropy;
    private String refreshTokenRollingGracePeriod;
    private String refreshRollingInterval;
    private String refreshRollingIntervalTimeUnit;
    private String refreshTokenLength;
    private String persistentGrantLifetime;
    private String persistentGrantLifetimeUnit;
    private String persistentGrantLifetimeType;
    private String persistentGrantIdleTimeout;
    private String persistentGrantIdleTimeoutTimeUnit;
    private String persistentGrantIdleTimeoutType;
    private boolean bypassAuthorizationForApprovedGrants;
    private List<GrantType> persistentGrantReuseGrantTypes;
    private List<ScopeEntry> scopes;
    private List<ScopeGroupEntry> scopeGroups;
    private List<ScopeEntry> exclusiveScopes;
    private List<ScopeGroupEntry> exclusiveScopeGroups;
    private List<PersistentGrantAttribute> persistentGrantCoreAttributes;
    private List<PersistentGrantAttribute> persistentGrantExtendedAttributes;
    private List<String> allowedOrigins;
    private String tokenEndpointBaseUrl;
    private String userAuthzUrl;
    private String registeredAuthzPath;
    private String pendingAuthzTimeout;
    private String devicePollingInterval;
    private String atmIdForOAuthGrantManagement;
    private String scopeForOAuthGrantManagement;
    private String authzConsentPageSettings;
    private String externalConsentAdapterId;
    private String returnedScopeAttributeName;
    private String returnedAuthorizationDetailsAttributeName;
    private String parReferenceTimeout;
    private String parReferenceLength;
    private String clientSecretRetentionPeriod;
    private String jwtSecuredAuthorizationResponseModeLifetime;
    private String dpopProofLifetimeSeconds;
    private boolean bypassAuthorizationForApprovedConsents;
    private boolean consentsDoNotExpire;
    private String consentLifetimeDays;
    private boolean validateScope = true;
    public static final Predicate<IdpAuthenticationAdapter> IS_V2_ADAPTER = adapter -> adapter instanceof IdpAuthenticationAdapterV2;
    public static final Predicate<IdpAuthenticationAdapter> EXTERNAL_CONSENT_PAGE_ADAPTER_FILTER = adapter -> {
        try {
            if (adapter instanceof IdpAuthenticationAdapterV2) {
                IdpAuthenticationAdapterV2 adapterV2 = (IdpAuthenticationAdapterV2)adapter;
                return adapterV2.getAdapterInfo() != null && adapterV2.getAdapterInfo().get("com.pingidentity.adapter.info.external.consent.adapter") != null && Boolean.parseBoolean(adapterV2.getAdapterInfo().get("com.pingidentity.adapter.info.external.consent.adapter").toString());
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    };

    public static AuthorizationServerSettingsValidator createInstanceForCrossOriginResourceSettingsValidation(List<String> allowedOrigins) {
        return new AuthorizationServerSettingsValidator(allowedOrigins);
    }

    public AuthorizationServerSettingsValidator(String authCodeTimeout, String authCodeEntropy, String refreshTokenRollingGracePeriod, String refreshRollingInterval, String refreshRollingIntervalTimeUnit, String refreshTokenLength, String persistentGrantLifetime, String persistentGrantLifetimeUnit, String persistentGrantLifetimeType, String persistentGrantIdleTimeout, String persistentGrantIdleTimeoutTimeUnit, String persistentGrantIdleTimeoutType, boolean bypassAuthorizationForApprovedGrants, List<GrantType> persistentGrantReuseGrantTypes, List<ScopeEntry> scopes, List<ScopeGroupEntry> scopeGroups, List<PersistentGrantAttribute> persistentGrantCoreAttributes, List<PersistentGrantAttribute> persistentGrantExtendedAttributes, List<ScopeEntry> exclusiveScopes, List<ScopeGroupEntry> exclusiveScopeGroups, List<String> allowedOrigins, String tokenEndpointBaseUrl, String userAuthzUrl, String registeredAuthzPath, String pendingAuthzTimeout, String devicePollingInterval, boolean validateScope, String atmIdForOAuthGrantManagement, String scopeForOAuthGrantManagement, String authoriztionConsentPageSetting, String externalConsentAdapterId, String returnedScopeAttributeName, String returnedAuthorizationDetailsAttributeName, String parReferenceTimeout, String parReferenceLength, String clientSecretRetentionPeriod, String jwtSecuredAuthorizationResponseModeLifetime, String dpopProofLifetimeSeconds, boolean bypassAuthorizationForApprovedConsents, boolean consentsDoNotExpire, String consentLifetimeDays) {
        this.authCodeTimeout = authCodeTimeout;
        this.authCodeEntropy = authCodeEntropy;
        this.refreshTokenRollingGracePeriod = refreshTokenRollingGracePeriod;
        this.refreshRollingInterval = refreshRollingInterval;
        this.refreshRollingIntervalTimeUnit = refreshRollingIntervalTimeUnit;
        this.refreshTokenLength = refreshTokenLength;
        this.persistentGrantLifetime = persistentGrantLifetime;
        this.persistentGrantLifetimeUnit = persistentGrantLifetimeUnit;
        this.persistentGrantLifetimeType = persistentGrantLifetimeType;
        this.persistentGrantIdleTimeout = persistentGrantIdleTimeout;
        this.persistentGrantIdleTimeoutTimeUnit = persistentGrantIdleTimeoutTimeUnit;
        this.persistentGrantIdleTimeoutType = persistentGrantIdleTimeoutType;
        this.bypassAuthorizationForApprovedGrants = bypassAuthorizationForApprovedGrants;
        this.persistentGrantReuseGrantTypes = persistentGrantReuseGrantTypes;
        this.scopes = scopes;
        this.scopeGroups = scopeGroups;
        this.exclusiveScopes = exclusiveScopes;
        this.exclusiveScopeGroups = exclusiveScopeGroups;
        this.persistentGrantCoreAttributes = persistentGrantCoreAttributes;
        this.persistentGrantExtendedAttributes = persistentGrantExtendedAttributes;
        this.allowedOrigins = allowedOrigins;
        this.tokenEndpointBaseUrl = tokenEndpointBaseUrl;
        this.userAuthzUrl = userAuthzUrl;
        this.registeredAuthzPath = registeredAuthzPath;
        this.pendingAuthzTimeout = pendingAuthzTimeout;
        this.devicePollingInterval = devicePollingInterval;
        this.validateScope = validateScope;
        this.atmIdForOAuthGrantManagement = atmIdForOAuthGrantManagement;
        this.scopeForOAuthGrantManagement = scopeForOAuthGrantManagement;
        this.authzConsentPageSettings = authoriztionConsentPageSetting;
        this.externalConsentAdapterId = externalConsentAdapterId;
        this.returnedScopeAttributeName = returnedScopeAttributeName;
        this.returnedAuthorizationDetailsAttributeName = returnedAuthorizationDetailsAttributeName;
        this.parReferenceLength = parReferenceLength;
        this.parReferenceTimeout = parReferenceTimeout;
        this.clientSecretRetentionPeriod = clientSecretRetentionPeriod;
        this.jwtSecuredAuthorizationResponseModeLifetime = jwtSecuredAuthorizationResponseModeLifetime;
        this.dpopProofLifetimeSeconds = dpopProofLifetimeSeconds;
        this.bypassAuthorizationForApprovedConsents = bypassAuthorizationForApprovedConsents;
        this.consentsDoNotExpire = consentsDoNotExpire;
        this.consentLifetimeDays = consentLifetimeDays;
        this.appendScopeValidator();
    }

    private AuthorizationServerSettingsValidator(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        this.appendScopeValidator();
    }

    public AuthorizationServerSettingsValidator(AuthorizationServerSettings serverSettings) {
        this.authCodeTimeout = String.valueOf(serverSettings.getAuthorizationCodeTimeout());
        this.authCodeEntropy = String.valueOf(serverSettings.getAuthorizationCodeEntropy());
        this.refreshTokenLength = String.valueOf(serverSettings.getRefreshTokenLength());
        this.bypassAuthorizationForApprovedGrants = serverSettings.isBypassAuthorizationForApprovedGrants();
        this.persistentGrantReuseGrantTypes = serverSettings.getPersistentGrantReuseGrantTypes();
        this.scopes = serverSettings.getScopes();
        this.scopeGroups = serverSettings.getScopeGroups();
        this.exclusiveScopes = serverSettings.getExclusiveScopes();
        this.exclusiveScopeGroups = serverSettings.getExclusiveScopeGroups();
        this.persistentGrantCoreAttributes = new PersistentGrantContract().getCoreAttributes();
        this.persistentGrantExtendedAttributes = this.getAllPersistentGrantExtendedAttributes(serverSettings);
        this.allowedOrigins = serverSettings.getAllowedOrigins();
        this.tokenEndpointBaseUrl = serverSettings.getTokenEndpointBaseUrl();
        this.userAuthzUrl = serverSettings.getUserAuthorizationUrl();
        this.registeredAuthzPath = serverSettings.getRegisteredAuthorizationPath();
        this.pendingAuthzTimeout = String.valueOf(serverSettings.getPendingAuthorizationTimeout());
        this.devicePollingInterval = String.valueOf(serverSettings.getDevicePollingInterval());
        this.atmIdForOAuthGrantManagement = serverSettings.getAtmIdForOAuthGrantManagement();
        this.scopeForOAuthGrantManagement = serverSettings.getScopeForOAuthGrantManagement();
        this.authzConsentPageSettings = String.valueOf(serverSettings.getUserAuthorizationConsentPageSetting());
        this.externalConsentAdapterId = serverSettings.getUserAuthorizationConsentAdapter();
        this.returnedScopeAttributeName = serverSettings.getApprovedScopesAttribute();
        this.returnedAuthorizationDetailsAttributeName = serverSettings.getApprovedAuthorizationDetailAttribute();
        this.parReferenceTimeout = serverSettings.getParReferenceTimeout() == null ? null : String.valueOf(serverSettings.getParReferenceTimeout());
        this.parReferenceLength = serverSettings.getParReferenceLength() == null ? null : String.valueOf(serverSettings.getParReferenceLength());
        this.clientSecretRetentionPeriod = serverSettings.getClientSecretRetentionPeriod() == null ? null : String.valueOf(serverSettings.getClientSecretRetentionPeriod());
        this.jwtSecuredAuthorizationResponseModeLifetime = serverSettings.getJwtSecuredAuthorizationResponseModeLifetime() == null ? null : String.valueOf(serverSettings.getJwtSecuredAuthorizationResponseModeLifetime());
        this.dpopProofLifetimeSeconds = serverSettings.getDpopProofLifetimeSeconds() == null ? null : String.valueOf(serverSettings.getDpopProofLifetimeSeconds());
        this.persistentGrantLifetimeType = "NONE";
        if (serverSettings.getPersistentGrantLifetime() != null && serverSettings.getPersistentGrantLifetime() != -1L) {
            this.persistentGrantLifetime = String.valueOf(serverSettings.getPersistentGrantLifetime());
            this.persistentGrantLifetimeType = "SERVER_DEFAULT";
        }
        if (serverSettings.getPersistentGrantLifetimeUnit() != null) {
            switch (serverSettings.getPersistentGrantLifetimeUnit()) {
                case MINUTES: {
                    this.persistentGrantLifetimeUnit = "n";
                    break;
                }
                case HOURS: {
                    this.persistentGrantLifetimeUnit = "h";
                    break;
                }
                case DAYS: {
                    this.persistentGrantLifetimeUnit = "d";
                    break;
                }
            }
        }
        if (serverSettings.getPersistentGrantIdleTimeout() != null) {
            if (serverSettings.getPersistentGrantIdleTimeout() == -1L) {
                this.persistentGrantIdleTimeoutType = "NONE";
            } else {
                this.persistentGrantIdleTimeoutType = "SERVER_DEFAULT";
                this.persistentGrantIdleTimeout = String.valueOf(serverSettings.getPersistentGrantIdleTimeout());
            }
        }
        if (serverSettings.getPersistentGrantIdleTimeoutTimeUnit() != null) {
            switch (serverSettings.getPersistentGrantIdleTimeoutTimeUnit()) {
                case MINUTES: {
                    this.persistentGrantIdleTimeoutTimeUnit = "n";
                    break;
                }
                case HOURS: {
                    this.persistentGrantIdleTimeoutTimeUnit = "h";
                    break;
                }
                case DAYS: {
                    this.persistentGrantIdleTimeoutTimeUnit = "d";
                    break;
                }
            }
        }
        this.refreshTokenRollingGracePeriod = String.valueOf(serverSettings.getRefreshTokenRollingGracePeriod());
        if (serverSettings.getRefreshRollingInterval() != null) {
            this.refreshRollingInterval = String.valueOf(serverSettings.getRefreshRollingInterval());
        }
        String string = this.refreshRollingIntervalTimeUnit = serverSettings.getRefreshRollingIntervalTimeUnit() == null ? "h" : serverSettings.getRefreshRollingIntervalTimeUnit().getId();
        if (serverSettings.getAdminWebServicePcvRef() != null && serverSettings.getAdminWebServicePcvRef().getId() != null) {
            String pcvId = serverSettings.getAdminWebServicePcvRef().getId();
            this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)MgmtFactory.getCredentialValidatorManager(), pcvId, AuthorizationServerSettingsPaths.getPasswordCredentialValidatorLinkIdPath(), ApiMessageKey.password_credential_validator_not_found));
        }
        this.bypassAuthorizationForApprovedConsents = serverSettings.isBypassAuthorizationForApprovedConsents();
        if (serverSettings.getConsentLifetimeDays() != null) {
            this.consentsDoNotExpire = serverSettings.getConsentLifetimeDays() == -1;
            this.consentLifetimeDays = String.valueOf(serverSettings.getConsentLifetimeDays());
        } else {
            this.consentsDoNotExpire = true;
            this.consentLifetimeDays = String.valueOf(-1);
        }
        this.appendScopeValidator();
    }

    private void appendScopeValidator() {
        if (this.validateScope) {
            this.addValidator((Validator)new OauthScopeValidator(this.scopes, this.scopeGroups, this.exclusiveScopes, this.exclusiveScopeGroups, this.scopeForOAuthGrantManagement));
        }
    }

    private void validateTokenBaseUrlValidator() {
        if (StringUtils.isNotEmpty((String)this.tokenEndpointBaseUrl)) {
            PartnerUrlValidator validator = PartnerUrlValidatorFactory.getGenericValidator(this.tokenEndpointBaseUrl, false, AuthorizationServerSettingsPaths.getTokenEndpointBaseUrlPath());
            if (validator.validate() && ValidationUtil.endsWithForwardSlash((String)this.tokenEndpointBaseUrl)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_token_endpoint_base_url_ends_with_slash, AuthorizationServerSettingsPaths.getTokenEndpointBaseUrlPath()));
            } else {
                this.appendErrors(validator.getErrors());
            }
        }
    }

    private List<PersistentGrantAttribute> getAllPersistentGrantExtendedAttributes(AuthorizationServerSettings serverSettings) {
        ArrayList<PersistentGrantAttribute> attributes = new ArrayList<PersistentGrantAttribute>();
        if (serverSettings.getPersistentGrantContract() != null) {
            attributes.addAll(serverSettings.getPersistentGrantContract().getExtendedAttributes());
        }
        return attributes;
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateAuthCodePolicySettings();
        this.validateParSettings();
        this.validateRefreshTokenAndPersistentGrantSettings();
        this.validatePersistentGrantContract();
        this.validateCrossOriginResourceSettings();
        this.validateTokenBaseUrlValidator();
        this.validateDeviceFlowSettings();
        this.validateOAuthEnableGrantManagement();
        this.validateAuthzConsentSettngs();
        this.validateClientSecretRetentionPeriod();
        this.validateJwtSecuredAuthorizationResponseModeLifetime();
        this.validateDpopProofLifetimeSeconds();
        this.validateConsentLifetimeDays();
        return !this.hasErrors();
    }

    private void validatePersistentGrantContract() {
        PersistentGrantContractValidator validator = new PersistentGrantContractValidator(this.persistentGrantCoreAttributes, this.persistentGrantExtendedAttributes, AuthorizationServerSettingsPaths.getPersistentGrantContract());
        if (!validator.validate()) {
            this.appendErrors(validator.getErrors());
        }
    }

    private void validateParSettings() {
        int max;
        int min;
        ValidationErrorFactory vef = ValidationErrorFactory.getInstance();
        if (StringUtils.isNotEmpty((String)this.parReferenceTimeout) && !ValidationUtil.isValidInt((String)this.parReferenceTimeout, (int)(min = 1), (int)(max = 1800))) {
            this.appendError(vef.create(ApiMessageKey.oauth_auth_server_settings_par_timeout_invalid, "parReferenceTimeout", new Object[]{min, max}));
        }
        if (StringUtils.isNotEmpty((String)this.parReferenceLength) && !ValidationUtil.isValidInt((String)this.parReferenceLength, (int)(min = 20), (int)(max = 256))) {
            this.appendError(vef.create(ApiMessageKey.oauth_auth_server_settings_par_entropy_invalid, "parReferenceLength", new Object[]{min, max}));
        }
    }

    public void validateAuthCodePolicySettings() {
        if (!ValidationUtil.isValidInt((String)this.authCodeTimeout, (int)1, (int)3600)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_auth_code_timeout_invalid, AuthorizationServerSettingsPaths.getAuthorizationCodeTimeout(), new Object[]{1, 3600}));
        }
        if (!ValidationUtil.isValidInt((String)this.authCodeEntropy, (int)16, (int)256)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_auth_code_entropy_invalid, AuthorizationServerSettingsPaths.getAuthorizationCodeEntropy(), new Object[]{16, 256}));
        }
    }

    public void validateRefreshTokenAndPersistentGrantSettings() {
        long maxRefreshTokenRollingInterval;
        if (StringUtils.isNotEmpty((String)this.persistentGrantLifetime)) {
            if (!ValidationUtil.isValidLong((String)this.persistentGrantLifetime, (long)1L, (long)999L)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_lifetime_invalid, AuthorizationServerSettingsPaths.getPersistentGrantLifetime(), new Object[]{1L, 999L}));
            }
            if (this.persistentGrantLifetimeUnit == null || !PersistentGrantLifetimeHelper.getPersistentGrantSettingTimeUnits().contains(this.persistentGrantLifetimeUnit)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_lifetime_unit_invalid, AuthorizationServerSettingsPaths.getPersistentGrantLifetimeUnit()));
            }
        } else if (this.persistentGrantLifetimeType != null && !this.persistentGrantLifetimeType.equals("NONE")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_lifetime_invalid, AuthorizationServerSettingsPaths.getPersistentGrantLifetime(), new Object[]{1L, 999L}));
        }
        if (StringUtils.isNotEmpty((String)this.persistentGrantIdleTimeout)) {
            if (!ValidationUtil.isValidLong((String)this.persistentGrantIdleTimeout, (long)1L, (long)999L)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_idle_timeout_invalid, AuthorizationServerSettingsPaths.getPersistentGrantIdleTimeout(), new Object[]{1L, 999L}));
            }
            if (this.persistentGrantIdleTimeoutTimeUnit == null || !PersistentGrantLifetimeHelper.getPersistentGrantSettingTimeUnits().contains(this.persistentGrantIdleTimeoutTimeUnit)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_idle_timeout_unit_invalid, AuthorizationServerSettingsPaths.getPersistentGrantIdleTimeoutTimeUnit()));
            }
        } else if (this.persistentGrantIdleTimeoutType != null && !this.persistentGrantIdleTimeoutType.equals("NONE")) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_idle_timeout_invalid, AuthorizationServerSettingsPaths.getPersistentGrantIdleTimeout(), new Object[]{1L, 999L}));
        }
        if (this.persistentGrantIdleTimeoutType == null) {
            if (PersistentGrantLifetimeHelper.getGlobalTimeSettingInMinutes((String)"SERVER_DEFAULT", (String)this.DEFAULT_GLOBAL_PERSISTENT_GRANT_IDLE_TIMEOUT, (String)this.DEFAULT_GLOBAL_PERSISTENT_GRANT_IDLE_TIMEOUT_UNIT) > PersistentGrantLifetimeHelper.getGlobalTimeSettingInMinutes((String)this.persistentGrantLifetimeType, (String)this.persistentGrantLifetime, (String)this.persistentGrantLifetimeUnit)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_idle_timeout_greater_than_max_lifetime, AuthorizationServerSettingsPaths.getPersistentGrantIdleTimeout()));
            }
        } else if (!"NONE".equals(this.persistentGrantIdleTimeoutType) && PersistentGrantLifetimeHelper.getGlobalTimeSettingInMinutes((String)this.persistentGrantIdleTimeoutType, (String)this.persistentGrantIdleTimeout, (String)this.persistentGrantIdleTimeoutTimeUnit) > PersistentGrantLifetimeHelper.getGlobalTimeSettingInMinutes((String)this.persistentGrantLifetimeType, (String)this.persistentGrantLifetime, (String)this.persistentGrantLifetimeUnit)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_persistent_grant_idle_timeout_greater_than_max_lifetime, AuthorizationServerSettingsPaths.getPersistentGrantIdleTimeout()));
        }
        if (!ValidationUtil.isValidInt((String)this.refreshTokenLength, (int)28, (int)256)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_refresh_token_length_invalid, AuthorizationServerSettingsPaths.getRefreshTokenLength(), new Object[]{28, 256}));
        }
        if (!ValidationUtil.isValidLong((String)this.refreshTokenRollingGracePeriod, (long)0L, (long)86400L)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_refresh_token_rolling_grace_period_invalid, AuthorizationServerSettingsPaths.getRefreshTokenRollingGracePeriod(), new Object[]{0L, 86400L}));
        }
        if (!ValidationUtil.isValidLong((String)this.refreshRollingInterval, (long)0L, (long)(maxRefreshTokenRollingInterval = RefreshTokenRollingIntervalHelper.getMaxIntervalForUnit((String)this.refreshRollingIntervalTimeUnit)))) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_refresh_rolling_interval_invalid, AuthorizationServerSettingsPaths.getRefreshRollingInterval(), new Object[]{0, maxRefreshTokenRollingInterval}));
        }
        if (this.bypassAuthorizationForApprovedGrants && (this.persistentGrantReuseGrantTypes == null || !this.persistentGrantReuseGrantTypes.contains(GrantType.AUTHORIZATION_CODE))) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_bypass_auth_for_approved_grants_invalid, AuthorizationServerSettingsPaths.getBypassAuthorizationForApprovedGrants()));
        }
    }

    public void validateCrossOriginResourceSettings() {
        if (this.allowedOrigins != null) {
            this.validateUniqueAllowedOrigins(this.allowedOrigins);
            UrlMatchingServiceMultipleStarImpl urlMatchingService = new UrlMatchingServiceMultipleStarImpl();
            for (String allowedOrigin : this.allowedOrigins) {
                if (urlMatchingService.isValidUrlPattern(allowedOrigin)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_cors_origin_invalid, AuthorizationServerSettingsPaths.getAllowedOriginsPath()));
            }
        }
    }

    private void validateUniqueAllowedOrigins(List<String> allowedOrigins) {
        UniqueEntriesValidator.UniqueKeyGetter<String> allowedOriginUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

            @Override
            public String getKey(String object) {
                return object;
            }
        };
        UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(allowedOriginUniqueKeyGetter, allowedOrigins, AuthorizationServerSettingsPaths.getAllowedOriginsPath(), ApiMessageKey.oauth_auth_server_settings_cors_origin_duplicate_entry);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    public void setValidateScope(boolean validateScope) {
        this.validateScope = validateScope;
    }

    private void validateDeviceFlowSettings() {
        String devicePollingIntervalPath;
        IntegerValidator devicePollingIntervalOverrideValidator;
        String pendingAuthorizationTimeoutPath;
        IntegerValidator pendingAuthorizationTimeoutOverrideValidator;
        String registeredAuthorizationPathPath;
        RelativePathValidator relativePathValidator;
        if (StringUtils.isNotBlank((String)this.userAuthzUrl)) {
            String userAuthorizationUrlPath = AuthorizationServerSettingsPaths.getUserAuthorizationUrlPath();
            if (!ValidationUtil.isValidHttpOrHttpsUrl((String)this.userAuthzUrl)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_url, userAuthorizationUrlPath, new Object[]{this.userAuthzUrl}));
            }
        }
        if (!(relativePathValidator = new RelativePathValidator(this.registeredAuthzPath, "Registered Authorization Path", registeredAuthorizationPathPath = AuthorizationServerSettingsPaths.getRegisteredAuthorizationPathPath(), false)).validate()) {
            this.appendErrors(relativePathValidator.getErrors());
        }
        if (!(pendingAuthorizationTimeoutOverrideValidator = new IntegerValidator(this.pendingAuthzTimeout, "Pending Authorization Timeout", pendingAuthorizationTimeoutPath = AuthorizationServerSettingsPaths.getPendingAuthorizationTimeoutPath(), true, 1, 3600)).validate()) {
            this.appendErrors(pendingAuthorizationTimeoutOverrideValidator.getErrors());
        }
        if (!(devicePollingIntervalOverrideValidator = new IntegerValidator(this.devicePollingInterval, "Device Polling Interval", devicePollingIntervalPath = AuthorizationServerSettingsPaths.getDevicePollingIntervalPath(), true, 1, 3600)).validate()) {
            this.appendErrors(devicePollingIntervalOverrideValidator.getErrors());
        }
    }

    private void validateAuthzConsentSettngs() {
        if (UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(this.authzConsentPageSettings)) {
            IdpAdapterManager idpAdapterMgr = MgmtFactory.getIdpAdapterManager();
            AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
            IdpAuthnAdapterInstance adapterInstance = null;
            IdpAuthenticationAdapter adapterType = null;
            if (StringUtils.isNotBlank((String)this.externalConsentAdapterId) && (adapterInstance = (IdpAuthnAdapterInstance)idpAdapterMgr.getInstance(this.externalConsentAdapterId)) != null) {
                adapterType = adapterMgr.getIdpAuthnAdapter(adapterInstance.getId());
            }
            if (StringUtils.isBlank((String)this.externalConsentAdapterId) || adapterInstance == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_invalid_adapter_id, AuthorizationServerSettingsPaths.getUserAuthorizationConsentAdapterPath(), new Object[]{this.userAuthzUrl}));
            } else if (adapterType != null && !IS_V2_ADAPTER.test(adapterType)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_invalid_adapter_type, AuthorizationServerSettingsPaths.getUserAuthorizationConsentAdapterPath(), new Object[]{this.userAuthzUrl}));
            }
            if (adapterType != null && !EXTERNAL_CONSENT_PAGE_ADAPTER_FILTER.test(adapterType)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_invalid_adapter_not_consent, AuthorizationServerSettingsPaths.getUserAuthorizationConsentAdapterPath(), new Object[]{this.userAuthzUrl}));
            }
            if (adapterInstance != null) {
                if (StringUtils.isBlank((String)this.returnedScopeAttributeName) && StringUtils.isBlank((String)this.returnedAuthorizationDetailsAttributeName)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_consent_attribute_required, AuthorizationServerSettingsPaths.getApprovedScopesAttributePath()));
                } else {
                    if (StringUtils.isNotBlank((String)this.returnedScopeAttributeName) && !this.isValid(this.returnedScopeAttributeName, adapterInstance)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_invalid_approved_scopes_attribute, AuthorizationServerSettingsPaths.getApprovedScopesAttributePath()));
                    }
                    if (StringUtils.isNotBlank((String)this.returnedAuthorizationDetailsAttributeName) && !this.isValid(this.returnedAuthorizationDetailsAttributeName, adapterInstance)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_invalid_approved_authorization_detail_attribute, AuthorizationServerSettingsPaths.getApprovedAuthorizationDetailAttributePath()));
                    }
                    if (Objects.equals(this.returnedScopeAttributeName, this.returnedAuthorizationDetailsAttributeName)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_invalid_approved_duplicate_attribute, AuthorizationServerSettingsPaths.getApprovedScopesAttributePath()));
                    }
                }
            }
        }
    }

    private boolean isValid(String returnedAttributeName, IdpAuthnAdapterInstance adapter) {
        if (adapter != null) {
            return adapter.getAttributeContract().getAllAttributeNames().contains(returnedAttributeName);
        }
        return false;
    }

    protected void validateOAuthEnableGrantManagement() {
        if (StringUtils.isNotBlank((String)this.atmIdForOAuthGrantManagement) && StringUtils.isBlank((String)this.scopeForOAuthGrantManagement)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_must_have_both_atm_and_scope, AuthorizationServerSettingsPaths.getScopeForOAuthGrantManagementPath()));
        } else if (StringUtils.isNotBlank((String)this.scopeForOAuthGrantManagement) && StringUtils.isBlank((String)this.atmIdForOAuthGrantManagement)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_must_have_both_atm_and_scope, AuthorizationServerSettingsPaths.getAtmIdForGrantManagementPath()));
        } else if (StringUtils.isNotBlank((String)this.scopeForOAuthGrantManagement) && StringUtils.isNotBlank((String)this.atmIdForOAuthGrantManagement)) {
            ConfigurablePluginInstance managerInstance = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.atmIdForOAuthGrantManagement);
            if (managerInstance == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_undefined_access_token_manager_id, AuthorizationServerSettingsPaths.getAtmIdForGrantManagementPath()));
            }
            if (!this.validateScope && !ScopeUtil.getAllScopeNames().contains(this.scopeForOAuthGrantManagement)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_auth_server_settings_undefined_scope_id, AuthorizationServerSettingsPaths.getScopeForOAuthGrantManagementPath()));
            }
        }
    }

    private void validateClientSecretRetentionPeriod() {
        ClientSecretRetentionPeriodValidator clientSecretRetentionPeriodValidator = new ClientSecretRetentionPeriodValidator(this.clientSecretRetentionPeriod);
        if (!clientSecretRetentionPeriodValidator.validate()) {
            this.appendErrors(clientSecretRetentionPeriodValidator.getErrors());
        }
    }

    private void validateJwtSecuredAuthorizationResponseModeLifetime() {
        boolean isRequired;
        String friendlyName = "JWT Secured Authorization Response Mode Lifetime";
        String jarmLifetimePath = AuthorizationServerSettingsPaths.getJwtSecuredAuthorizationResponseModeLifetimePath();
        IntegerValidator jarmLifetimeValidator = new IntegerValidator(this.jwtSecuredAuthorizationResponseModeLifetime, friendlyName, jarmLifetimePath, isRequired = false, 1, 3600);
        if (!jarmLifetimeValidator.validate()) {
            this.appendErrors(jarmLifetimeValidator.getErrors());
        }
    }

    void validateDpopProofLifetimeSeconds() {
        IntegerValidator dpopProofLifeTimeValidator = new IntegerValidator(this.dpopProofLifetimeSeconds, "DPoP Proof JWT Lifetime (seconds)", AuthorizationServerSettingsPaths.getDpopProofLifetimeSecondsPath(), false, 1, 3600);
        if (!dpopProofLifeTimeValidator.validate()) {
            this.appendErrors(dpopProofLifeTimeValidator.getErrors());
        }
    }

    private void validateConsentLifetimeDays() {
        IntegerValidator consentLifeTimeValidator;
        if (this.bypassAuthorizationForApprovedConsents && !this.consentsDoNotExpire && !(consentLifeTimeValidator = new IntegerValidator(this.consentLifetimeDays, "Consent Max Lifetime (days)", AuthorizationServerSettingsPaths.getConsentLifetimeDaysPath(), true, 1, 999)).validate()) {
            this.appendErrors(consentLifeTimeValidator.getErrors());
        }
    }
}

