/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.bulkconfig.BulkConfigMetadata;
import com.pingidentity.admin.api.model.fieldpaths.BulkConfigPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.VersionUtil;

public class BulkConfigMetadataValidator
extends AbstractValidator {
    private BulkConfigMetadata metadata;

    public BulkConfigMetadataValidator(BulkConfigMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean validate() {
        if (StringUtils.isNotBlank((String)this.metadata.getPfVersion())) {
            try {
                String installVersion = PropertyInfo.getPingFederateVersion();
                if (VersionUtil.compareProductMajorMinorVersions((String)installVersion, (String)this.metadata.getPfVersion()) < 0) {
                    ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_version_error, BulkConfigPaths.getMetadataVersion(), new Object[]{this.metadata.getPfVersion(), PropertyInfo.getPingFederateVersion()});
                    this.appendError(error);
                }
            }
            catch (RuntimeException ex) {
                ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.format_invalid, BulkConfigPaths.getMetadataVersion(), new Object[]{"pfVersion"});
                this.appendError(error);
            }
        } else {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, BulkConfigPaths.getMetadataVersion(), new Object[]{"pfVersion"});
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

