/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.CertificateRevocationSettings;
import com.pingidentity.admin.api.model.CrlSettings;
import com.pingidentity.admin.api.model.OcspSettings;
import com.pingidentity.admin.api.model.ProxySettings;
import com.pingidentity.admin.api.model.fieldpaths.CertificateRevocationCheckingPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.OCSPCheckerSupport;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class CertificateRevocationCheckingValidator
extends AbstractValidator {
    private OcspSettings ocspSettings;
    private CrlSettings crlSettings;
    private ProxySettings proxySettings;
    private PkCertAndConnectionCertManager certManager;
    private static final int DEFAULT_MAX_VALUE = 65535;

    public CertificateRevocationCheckingValidator(CertificateRevocationSettings settings, PkCertAndConnectionCertManager certManager) {
        this.ocspSettings = settings.getOcspSettings();
        this.crlSettings = settings.getCrlSettings();
        this.proxySettings = settings.getProxySettings();
        this.certManager = certManager;
    }

    public boolean validate() {
        if (this.ocspSettings != null) {
            if (this.ocspSettings.getResponderUrl() != null && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.ocspSettings.getResponderUrl())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.default_ocsp_url_invalid, CertificateRevocationCheckingPaths.getResponderUrl()));
            }
            if (!ValidationUtil.isValidInt((String)String.valueOf(this.ocspSettings.getCurrentUpdateGracePeriod()), (int)1, (int)65535)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.current_update_grace_period_invalid, CertificateRevocationCheckingPaths.getCurrentUpdateGracePeriod(), new Object[]{65535}));
            }
            if (!ValidationUtil.isValidInt((String)String.valueOf(this.ocspSettings.getNextUpdateGracePeriod()), (int)1, (int)65535)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.next_update_grace_period_invalid, CertificateRevocationCheckingPaths.getNextUpdateGracePeriod(), new Object[]{65535}));
            }
            if (!ValidationUtil.isValidInt((String)String.valueOf(this.ocspSettings.getResponderTimeout()), (int)1, (int)65535)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.responder_timeout_invalid, CertificateRevocationCheckingPaths.getResponderTimeout(), new Object[]{65535}));
            }
            if (!ValidationUtil.isValidInt((String)String.valueOf(this.ocspSettings.getResponseCachePeriod()), (int)0, (int)65535)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.response_cache_interval_invalid, CertificateRevocationCheckingPaths.getResponseCachePeriod(), new Object[]{65535}));
            }
            String errorActionFail = OCSPCheckerSupport.ACTION.FAIL.toString();
            String errorActionContinue = OCSPCheckerSupport.ACTION.CONTINUE.toString();
            String errorActionFailover = OCSPCheckerSupport.ACTION.FAILOVER.toString();
            HashSet<String> allowedOcspErrorHandlingVerbs = new HashSet<String>();
            allowedOcspErrorHandlingVerbs.add(errorActionFail);
            allowedOcspErrorHandlingVerbs.add(errorActionFailover);
            allowedOcspErrorHandlingVerbs.add(errorActionContinue);
            if (!allowedOcspErrorHandlingVerbs.contains(this.ocspSettings.getActionOnStatusUnknown())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.invalid_error_handling_method, CertificateRevocationCheckingPaths.getActionOnStatusUnknown(), new Object[]{errorActionContinue, errorActionFail, errorActionFailover}));
            }
            if (!allowedOcspErrorHandlingVerbs.contains(this.ocspSettings.getActionOnResponderUnavailable())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.invalid_error_handling_method, CertificateRevocationCheckingPaths.getActionOnResponderUnavailable(), new Object[]{errorActionContinue, errorActionFail, errorActionFailover}));
            }
            if (!allowedOcspErrorHandlingVerbs.contains(this.ocspSettings.getActionOnUnsuccessfulResponse())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.invalid_error_handling_method, CertificateRevocationCheckingPaths.getActionOnUnsuccessfulResponse(), new Object[]{errorActionContinue, errorActionFail, errorActionFailover}));
            }
            if (this.ocspSettings.getResponderCertReference() != null && !this.isCertAliasExisting(this.ocspSettings.getResponderCertReference().getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.invalid_ocsp_cert_alias, CertificateRevocationCheckingPaths.getResponderCertReferenceId()));
            }
            boolean failoverEnabledOnUnknown = errorActionFailover.equals(this.ocspSettings.getActionOnStatusUnknown());
            boolean failoverEnabledOnUnsuccessful = errorActionFailover.equals(this.ocspSettings.getActionOnUnsuccessfulResponse());
            boolean failoverEnabledOnUnavailable = errorActionFailover.equals(this.ocspSettings.getActionOnResponderUnavailable());
            if (failoverEnabledOnUnknown || failoverEnabledOnUnsuccessful || failoverEnabledOnUnavailable) {
                if (this.crlSettings == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.failover_defined_no_crl, CertificateRevocationCheckingPaths.getCrlSettings()));
                }
            } else if (this.crlSettings != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.no_failover_defined_but_crl_is, CertificateRevocationCheckingPaths.getCrlSettings()));
            }
        }
        if (this.crlSettings != null) {
            if (!ValidationUtil.isValidInt((String)String.valueOf(this.crlSettings.getNextRetryMinsWhenResolveFailed()), (int)1, (int)65535)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.resolution_failure_invalid, CertificateRevocationCheckingPaths.getNextRetryMinsWhenResolveFailed(), new Object[]{65535}));
            }
            if (!ValidationUtil.isValidInt((String)String.valueOf(this.crlSettings.getNextRetryMinsWhenNextUpdateInPast()), (int)1, (int)65535)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.update_expiration_invalid, CertificateRevocationCheckingPaths.getNextRetryMinsWhenNextUpdateInPast(), new Object[]{65535}));
            }
        }
        if (this.proxySettings != null) {
            if (StringUtils.isBlank((String)this.proxySettings.getHost())) {
                if (StringUtils.isNotBlank((String)String.valueOf(this.proxySettings.getPort()))) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.proxy_host_required, CertificateRevocationCheckingPaths.getHost()));
                }
            } else if (!ValidationUtil.isValidDomainName((String)this.proxySettings.getHost())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.proxy_host_invalid, CertificateRevocationCheckingPaths.getHost()));
            }
            if (StringUtils.isBlank((String)String.valueOf(this.proxySettings.getPort()))) {
                if (StringUtils.isNotBlank((String)this.proxySettings.getHost())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.proxy_port_required, CertificateRevocationCheckingPaths.getPort()));
                }
            } else if (!ValidationUtil.isValidPort((String)String.valueOf(this.proxySettings.getPort()), (boolean)false)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.proxy_port_invalid, CertificateRevocationCheckingPaths.getPort(), new Object[]{65535}));
            }
        }
        return !this.hasErrors();
    }

    private boolean isCertAliasExisting(String id) {
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        Set verificationCerts = this.certManager.getCertsForFeature("Revocation Settings OCSP Responder Certs");
        for (Cert cert : verificationCerts) {
            if (!id.equals(cert.getAlias())) continue;
            return true;
        }
        return false;
    }
}

