/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.CryptoProvider;
import com.pingidentity.admin.api.model.fieldpaths.NewKeyPairSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.crypto.KeyPairFileFormat;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pingcommons.bcfips.ImportExportException;
import com.pingidentity.pingcommons.crypto.B64;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class CertificateValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CertificateValidator.class);
    private InputStream certStream;
    private String password;
    private boolean certOnly = true;
    private Cert cert;
    private String fileDataFieldPath;
    private KeyPairFileFormat keyPairFileFormat;
    private String passwordFieldPath;
    private Set<Cert> existingCerts = null;
    private boolean checkValid = true;
    private boolean validateCryptoProvider;
    private CryptoProvider cryptoProvider;
    private final CertificateGenerator certService;
    private final ValidationErrorFactory validationErrorFactory;

    private CertificateValidator(CertificateGenerator certService, ValidationErrorFactory validationErrorFactory) {
        this.certService = certService;
        this.validationErrorFactory = validationErrorFactory;
    }

    public CertificateValidator(InputStream certStream, String fileDataFieldPath) {
        this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance());
        this.certStream = certStream;
        this.fileDataFieldPath = fileDataFieldPath;
    }

    public CertificateValidator(InputStream certStream, String fileDataFieldPath, Set<Cert> existingCerts, boolean checkValid) {
        this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance());
        this.certStream = certStream;
        this.fileDataFieldPath = fileDataFieldPath;
        this.existingCerts = existingCerts;
        this.checkValid = checkValid;
    }

    public CertificateValidator(InputStream certStream, String fileDataFieldPath, KeyPairFileFormat keyPairFileFormat, String password, String passwordFieldPath, Set<Cert> existingCerts, boolean checkValid) {
        this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance());
        this.certStream = certStream;
        this.password = password;
        this.fileDataFieldPath = fileDataFieldPath;
        this.keyPairFileFormat = keyPairFileFormat;
        this.passwordFieldPath = passwordFieldPath;
        this.certOnly = false;
        this.existingCerts = existingCerts;
        this.checkValid = checkValid;
    }

    public CertificateValidator(String certString, String fileDataFieldPath) {
        this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance());
        this.certStream = certString.startsWith("-----BEGIN") ? new ByteArrayInputStream(certString.getBytes(StandardCharsets.UTF_8)) : new ByteArrayInputStream(B64.decodeToBytes((String)certString));
        this.fileDataFieldPath = fileDataFieldPath;
    }

    public CertificateValidator(String certString, String fileDataFieldPath, boolean checkValid) {
        this(certString, fileDataFieldPath);
        this.checkValid = checkValid;
    }

    public CertificateValidator(String certString, String fileDataFieldPath, Set<Cert> existingCerts, boolean checkValid) {
        this(certString, fileDataFieldPath, checkValid);
        this.existingCerts = existingCerts;
    }

    public CertificateValidator(InputStream certStream, String fileDataFieldPath, String password, String passwordFieldPath) {
        this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance());
        this.certStream = certStream;
        this.password = password;
        this.fileDataFieldPath = fileDataFieldPath;
        this.passwordFieldPath = passwordFieldPath;
        this.certOnly = false;
    }

    public Cert getCert() {
        return this.cert;
    }

    public PkCert getPkCert() {
        if (!this.certOnly) {
            return (PkCert)this.cert;
        }
        return null;
    }

    public boolean validate() {
        try {
            if (this.certOnly) {
                this.cert = Cert.importCert((InputStream)this.certStream, (boolean)this.checkValid);
            } else if (StringUtils.isNotBlank((String)this.password)) {
                this.cert = this.keyPairFileFormat != null ? PkCert.importKeyPair((InputStream)this.certStream, (KeyPairFileFormat)this.keyPairFileFormat, (String)this.password, (boolean)this.checkValid) : PkCert.importKeyPair((InputStream)this.certStream, (String)this.password, (boolean)this.checkValid);
                if (this.cert == null) {
                    this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_no_key_or_cert_found, this.fileDataFieldPath));
                } else if (!"OFF".equalsIgnoreCase(System.getProperty("pf.hsm.mode"))) {
                    KeyAlgorithmInfo info = this.certService.getKeyAlgorithmInfo(this.cert.getPublicKeyAlgorithm());
                    if (info == null) {
                        this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_error_no_key_size, this.fileDataFieldPath));
                    } else if (!info.getKeySizes().contains(this.cert.getPublicKeySize())) {
                        this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_invalid_key_size, this.fileDataFieldPath));
                    }
                }
            } else {
                this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_password_required, this.passwordFieldPath));
            }
            this.appendErrorUponDuplication();
        }
        catch (IOException io) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Importing cert file caused an exception: " + io), (Throwable)io);
            }
            if (StringUtils.isNotBlank((String)io.getMessage()) && (io.getMessage().contains("failed to decrypt safe contents entry") || io.getMessage().contains("keystore password was incorrect"))) {
                this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_incorrect_password, this.passwordFieldPath));
            } else {
                this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_error_importing_key_pair_file, this.fileDataFieldPath));
            }
        }
        catch (ImportExportException ex) {
            log.debug((Object)("Importing PEM formatted key pair file caused an exception: " + ex), (Throwable)ex);
            if (ex.getCause() != null && ex.getCause().getCause() instanceof InvalidCipherTextException) {
                this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_incorrect_password, this.passwordFieldPath));
            } else {
                this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_error_invalid_key_pair, this.fileDataFieldPath, new Object[]{ex.getMessage()}));
            }
        }
        catch (CertificateParsingException certParsingEx) {
            log.debug((Object)("Importing cert file caused an exception: " + certParsingEx));
            this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_certificate_parsing_exception, this.fileDataFieldPath));
        }
        catch (CertificateExpiredException certExpiredEx) {
            log.debug((Object)("Importing cert file caused an exception: " + certExpiredEx));
            this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_certificate_expired, this.fileDataFieldPath));
        }
        catch (CertificateNotYetValidException certNotYetValidEx) {
            log.debug((Object)("Importing cert file caused an exception: " + certNotYetValidEx));
            this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_certificate_not_yet_valid, this.fileDataFieldPath));
        }
        catch (GeneralSecurityException keyEx) {
            log.debug((Object)("Importing cert file caused an exception: " + keyEx));
            this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_error_importing_file, this.fileDataFieldPath));
        }
        if (this.validateCryptoProvider) {
            if (this.certOnly) {
                if (("LUNA".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) || !this.isHybridMode()) && this.cryptoProvider != null) {
                    this.appendError(this.validationErrorFactory.create(ApiMessageKey.crypto_provider_invalid_luna, NewKeyPairSettingsPaths.getCryptoProvider()));
                }
            } else if (!this.isHybridMode() && this.cryptoProvider != null) {
                this.appendError(this.validationErrorFactory.create(ApiMessageKey.crypto_provider_invalid, NewKeyPairSettingsPaths.getCryptoProvider()));
            }
            if (!(this.hasErrors() || this.cert == null || this.certOnly && "LUNA".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) || !this.isHybridMode() || this.cryptoProvider == null)) {
                if (CryptoProvider.HSM == this.cryptoProvider) {
                    this.cert.setStoredOnHSM(Boolean.valueOf(true));
                } else {
                    this.cert.setStoredOnHSM(Boolean.valueOf(false));
                }
            }
        }
        return !this.hasErrors();
    }

    private boolean isHybridMode() {
        return Boolean.getBoolean("pf.hsm.hybrid") && !"OFF".equalsIgnoreCase(System.getProperty("pf.hsm.mode"));
    }

    private void appendErrorUponDuplication() {
        if (this.existingCerts == null || this.cert == null) {
            return;
        }
        String newCertHas = this.cert.getFingerPrint(HashAlgorithm.SHA256);
        for (Cert cert : this.existingCerts) {
            if (!newCertHas.equals(cert.getFingerPrint(HashAlgorithm.SHA256))) continue;
            this.appendError(this.validationErrorFactory.create(ApiMessageKey.cert_import_duplication_error, this.fileDataFieldPath));
            return;
        }
    }

    private void setCertStream(InputStream certStream) {
        this.certStream = certStream;
    }

    private void setPassword(String password) {
        this.password = password;
    }

    private void setCertOnly(boolean certOnly) {
        this.certOnly = certOnly;
    }

    private void setCert(Cert cert) {
        this.cert = cert;
    }

    private void setFileDataFieldPath(String fileDataFieldPath) {
        this.fileDataFieldPath = fileDataFieldPath;
    }

    private void setKeyPairFileFormat(KeyPairFileFormat keyPairFileFormat) {
        this.keyPairFileFormat = keyPairFileFormat;
    }

    private void setPasswordFieldPath(String passwordFieldPath) {
        this.passwordFieldPath = passwordFieldPath;
    }

    private void setExistingCerts(Set<Cert> existingCerts) {
        this.existingCerts = existingCerts;
    }

    private void setCheckValid(boolean checkValid) {
        this.checkValid = checkValid;
    }

    public void setValidateCryptoProvider(boolean validateCryptoProvider) {
        this.validateCryptoProvider = validateCryptoProvider;
    }

    public void setCryptoProvider(CryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void checkDuplicateId(String id, PkCertManager pkCertManager, ApiMessageKey msgKey, String fieldPath) {
        if (pkCertManager.getPkCert(id) != null) {
            this.appendError(this.validationErrorFactory.create(msgKey, fieldPath));
        }
    }

    public void checkDuplicateId(String id, TrustedCAsManager trustedCAsManager, ApiMessageKey msgKey, String fieldPath) {
        if (trustedCAsManager.getCert(id) != null) {
            this.appendError(this.validationErrorFactory.create(msgKey, fieldPath));
        }
    }

    public static class CertificateValidatorBuilder {
        private final CertificateGenerator certService;
        private final ValidationErrorFactory validationErrorFactory;
        private final InputStream certStream;
        private final String fileDataFieldPath;
        private String password;
        private boolean certOnly = false;
        private Cert cert;
        private KeyPairFileFormat keyPairFileFormat;
        private String passwordFieldPath;
        private Set<Cert> existingCerts = null;
        private boolean checkValid = true;
        private boolean validateCryptoProvider;
        private CryptoProvider cryptoProvider;

        public CertificateValidatorBuilder(CertificateGenerator certService, ValidationErrorFactory validationErrorFactory, InputStream certStream, String fileDataFieldPath) {
            this.certService = certService;
            this.validationErrorFactory = validationErrorFactory;
            this.certStream = certStream;
            this.fileDataFieldPath = fileDataFieldPath;
        }

        public CertificateValidatorBuilder(InputStream certStream, String fileDataFieldPath) {
            this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance(), certStream, fileDataFieldPath);
        }

        public CertificateValidatorBuilder(CertificateGenerator certService, ValidationErrorFactory validationErrorFactory, String certString, String fileDataFieldPath) {
            this.certService = certService;
            this.validationErrorFactory = validationErrorFactory;
            this.certStream = certString.startsWith("-----BEGIN") ? new ByteArrayInputStream(certString.getBytes(StandardCharsets.UTF_8)) : new ByteArrayInputStream(B64.decodeToBytes((String)certString));
            this.fileDataFieldPath = fileDataFieldPath;
        }

        public CertificateValidatorBuilder(String certString, String fileDataFieldPath) {
            this((CertificateGenerator)MgmtFactory.getCertificateService(), ValidationErrorFactory.getInstance(), certString, fileDataFieldPath);
        }

        public CertificateValidatorBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public CertificateValidatorBuilder setCertOnly(boolean certOnly) {
            this.certOnly = certOnly;
            return this;
        }

        public CertificateValidatorBuilder setCert(Cert cert) {
            this.cert = cert;
            return this;
        }

        public CertificateValidatorBuilder setKeyPairFileFormat(KeyPairFileFormat keyPairFileFormat) {
            this.keyPairFileFormat = keyPairFileFormat;
            return this;
        }

        public CertificateValidatorBuilder setPasswordFieldPath(String passwordFieldPath) {
            this.passwordFieldPath = passwordFieldPath;
            return this;
        }

        public CertificateValidatorBuilder setExistingCerts(Set<Cert> existingCerts) {
            this.existingCerts = existingCerts;
            return this;
        }

        public CertificateValidatorBuilder setCheckValid(boolean checkValid) {
            this.checkValid = checkValid;
            return this;
        }

        public CertificateValidatorBuilder setValidateCryptoProvider(boolean validateCryptoProvider) {
            this.validateCryptoProvider = validateCryptoProvider;
            return this;
        }

        public CertificateValidatorBuilder setCryptoProvider(CryptoProvider cryptoProvider) {
            this.cryptoProvider = cryptoProvider;
            return this;
        }

        public CertificateValidator build() {
            CertificateValidator certificateValidator = new CertificateValidator(this.certService, this.validationErrorFactory);
            certificateValidator.setCertStream(this.certStream);
            certificateValidator.setPassword(this.password);
            certificateValidator.setCertOnly(this.certOnly);
            certificateValidator.setCert(this.cert);
            certificateValidator.setFileDataFieldPath(this.fileDataFieldPath);
            certificateValidator.setKeyPairFileFormat(this.keyPairFileFormat);
            certificateValidator.setPasswordFieldPath(this.passwordFieldPath);
            certificateValidator.setExistingCerts(this.existingCerts);
            certificateValidator.setCheckValid(this.checkValid);
            certificateValidator.setValidateCryptoProvider(this.validateCryptoProvider);
            certificateValidator.setCryptoProvider(this.cryptoProvider);
            return certificateValidator;
        }
    }
}

