/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ChangeDetectionSettings;
import com.pingidentity.admin.api.model.SaasChangedUsersAlgorithm;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LdapDataSource;

public class ChangeDetectionSettingsValidator
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private ChangeDetectionSettings changeDetectionSettings;
    private int index;
    private LdapDataSource ldapDataSource;

    ChangeDetectionSettingsValidator(int index, ChangeDetectionSettings changeDetectionSettings, LdapDataSource ldapDataSource) {
        this.changeDetectionSettings = changeDetectionSettings;
        this.index = index;
        this.ldapDataSource = ldapDataSource;
        this.addValidator((Validator)new NotBlankValidator(changeDetectionSettings.getUserObjectClass(), ConnectionPaths.OutboundProvisionPaths.getUserObjectClass(index), ConnectionPaths.OutboundProvisionPaths.getUserObjectClass(index)));
        this.addValidator((Validator)new NotBlankValidator(changeDetectionSettings.getGroupObjectClass(), ConnectionPaths.OutboundProvisionPaths.getGroupObjectClass(index), ConnectionPaths.OutboundProvisionPaths.getGroupObjectClass(index)));
        this.addValidator((Validator)new NotBlankValidator(changeDetectionSettings.getTimeStampAttributeName(), ConnectionPaths.OutboundProvisionPaths.getTimeStampAttributeName(index), ConnectionPaths.OutboundProvisionPaths.getTimeStampAttributeName(index)));
        this.addValidator((Validator)new NotNullValidator((Object)changeDetectionSettings.getChangedUsersAlgorithm(), ConnectionPaths.OutboundProvisionPaths.getChangedUserAlgo(index), ConnectionPaths.OutboundProvisionPaths.getChangedUserAlgo(index)));
    }

    @Override
    public boolean validate() {
        super.validate();
        if (SaasChangedUsersAlgorithm.ACTIVE_DIRECTORY_USN == this.changeDetectionSettings.getChangedUsersAlgorithm()) {
            if (this.ldapDataSource != null && !this.ldapDataSource.isActiveDirectoryType()) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_changed_user_algo_invalid, ConnectionPaths.OutboundProvisionPaths.getChangedUserAlgo(this.index), new Object[]{SaasChangedUsersAlgorithm.ACTIVE_DIRECTORY_USN});
                this.appendError(error);
            } else if (StringUtils.isBlank((String)this.changeDetectionSettings.getUsnAttributeName())) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_usnAttributeName_required, ConnectionPaths.OutboundProvisionPaths.getUsnAttributeName(this.index), new Object[]{SaasChangedUsersAlgorithm.ACTIVE_DIRECTORY_USN});
                this.appendError(error);
            }
        } else if (StringUtils.isNotBlank((String)this.changeDetectionSettings.getUsnAttributeName())) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_usnAttributeName_required, ConnectionPaths.OutboundProvisionPaths.getUsnAttributeName(this.index), new Object[]{SaasChangedUsersAlgorithm.ACTIVE_DIRECTORY_USN});
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

