/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ChannelSourceLocation;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;

public class ChannelSourceLocationValidation
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private ChannelSourceLocation channelSourceLocation;
    private int index;
    private boolean isUserLocation;

    ChannelSourceLocationValidation(int index, boolean isUserLocation, ChannelSourceLocation channelSourceLocation) {
        this.channelSourceLocation = channelSourceLocation;
        this.index = index;
        this.isUserLocation = isUserLocation;
    }

    @Override
    public boolean validate() {
        String userOrGroup;
        String filter = this.channelSourceLocation.getFilter();
        String groupDN = this.channelSourceLocation.getGroupDN();
        if (this.isUserLocation) {
            userOrGroup = "User";
            if (StringUtils.isBlank((String)filter) && StringUtils.isBlank((String)groupDN)) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_groupDN_or_filter_required, ConnectionPaths.OutboundProvisionPaths.getUserGroupDN(this.index));
                this.appendError(error);
            }
        } else {
            userOrGroup = "Group";
        }
        if (!StringUtils.isBlank((String)filter) && !LDAPUtil.validateFilter((String)filter)) {
            String path = this.isUserLocation ? ConnectionPaths.OutboundProvisionPaths.getUserFilter(this.index) : ConnectionPaths.OutboundProvisionPaths.getGroupFilter(this.index);
            ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_filter_invalid, path, new Object[]{userOrGroup, filter});
            this.appendError(error);
        }
        if (!StringUtils.isEmpty((String)groupDN)) {
            try {
                new LdapName(groupDN);
            }
            catch (InvalidNameException e) {
                String path = this.isUserLocation ? ConnectionPaths.OutboundProvisionPaths.getUserGroupDN(this.index) : ConnectionPaths.OutboundProvisionPaths.getGroupGroupDN(this.index);
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_groupDN_invalid, path, new Object[]{userOrGroup, groupDN});
                this.appendError(error);
            }
        }
        return !this.hasErrors();
    }
}

