/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Channel;
import com.pingidentity.admin.api.model.ChannelSource;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AccountManagementSettingsValidator;
import com.pingidentity.admin.api.validator.ChangeDetectionSettingsValidator;
import com.pingidentity.admin.api.validator.ChannelSourceLocationValidation;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.GroupDnValidator;
import com.pingidentity.admin.api.validator.GroupMembershipDetectionValidation;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ChannelSourceValidator
extends CompositeValidator {
    private final DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private Channel channel;
    private int index;
    private LdapDataSource ldapDataSource;

    ChannelSourceValidator(int index, Channel channel) {
        this.channel = channel;
        this.index = index;
        ChannelSource channelSource = channel.getChannelSource();
        this.addValidator((Validator)new NotNullValidator(channelSource.getDataSource(), ConnectionPaths.OutboundProvisionPaths.getDataSourceId(index), ConnectionPaths.OutboundProvisionPaths.getDataSourceId(index)));
        this.addValidator((Validator)new NotBlankValidator(channelSource.getBaseDn(), ConnectionPaths.OutboundProvisionPaths.getBaseDN(index), ConnectionPaths.OutboundProvisionPaths.getBaseDN(index)));
        this.addValidator((Validator)new NotNullValidator(channelSource.getGuidAttributeName(), ConnectionPaths.OutboundProvisionPaths.getGuidAttributeName(index), ConnectionPaths.OutboundProvisionPaths.getGuidAttributeName(index)));
        this.addValidator((Validator)new NotNullValidator(channelSource.getChangeDetectionSettings(), ConnectionPaths.OutboundProvisionPaths.getChangeDetectionSettings(index), ConnectionPaths.OutboundProvisionPaths.getChangeDetectionSettings(index)));
        this.addValidator((Validator)new NotNullValidator(channelSource.getAccountManagementSettings(), ConnectionPaths.OutboundProvisionPaths.getAccountManagementSettings(index), ConnectionPaths.OutboundProvisionPaths.getAccountManagementSettings(index)));
        this.addValidator((Validator)new NotNullValidator(channelSource.getGroupMembershipDetection(), ConnectionPaths.OutboundProvisionPaths.getGroupMembership(index), ConnectionPaths.OutboundProvisionPaths.getGroupMembership(index)));
        this.addValidator((Validator)new NotNullValidator(channelSource.getUserSourceLocation(), ConnectionPaths.OutboundProvisionPaths.getUserSourceLocation(index), ConnectionPaths.OutboundProvisionPaths.getUserSourceLocation(index)));
        if (channelSource.getDataSource() != null) {
            this.addValidator((Validator)new NotBlankValidator(channelSource.getDataSource().getId(), ConnectionPaths.OutboundProvisionPaths.getDataSourceId(index), ConnectionPaths.OutboundProvisionPaths.getDataSourceId(index)));
            if (channelSource.getDataSource().getId() != null) {
                this.ldapDataSource = this.dataSourceManager.getLdapDataSource(channelSource.getDataSource().getId());
                if (this.ldapDataSource != null) {
                    this.addValidators(channelSource);
                }
            }
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        ChannelSource channelSource = this.channel.getChannelSource();
        ResourceLink dataStore = channelSource.getDataSource();
        if (dataStore != null) {
            if (this.ldapDataSource == null) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_invalid_data_source, ConnectionPaths.OutboundProvisionPaths.getDataSourceId(this.index), new Object[]{channelSource.getDataSource().getId()});
                this.appendError(error);
                return false;
            }
            try {
                new LdapName(channelSource.getBaseDn());
            }
            catch (InvalidNameException e) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_channel_baseDN_invalid, ConnectionPaths.OutboundProvisionPaths.getBaseDN(this.index), new Object[]{dataStore.getId(), channelSource.getBaseDn()});
                this.appendError(error);
            }
        }
        if (!this.hasErrors()) {
            super.clearValidators();
            this.addValidators(channelSource);
            return super.validate();
        }
        return !this.hasErrors();
    }

    private void addValidators(ChannelSource channelSource) {
        if (channelSource.getChangeDetectionSettings() != null) {
            this.addValidator((Validator)new ChangeDetectionSettingsValidator(this.index, channelSource.getChangeDetectionSettings(), this.ldapDataSource));
        }
        if (channelSource.getUserSourceLocation() != null) {
            this.addValidator((Validator)new ChannelSourceLocationValidation(this.index, true, channelSource.getUserSourceLocation()));
            this.addValidator((Validator)new GroupDnValidator(ConnectionPaths.OutboundProvisionPaths.getUserGroupDN(this.index), channelSource.getUserSourceLocation().getGroupDN()));
        }
        if (channelSource.getGroupSourceLocation() != null) {
            this.addValidator((Validator)new ChannelSourceLocationValidation(this.index, false, channelSource.getGroupSourceLocation()));
            this.addValidator((Validator)new GroupDnValidator(ConnectionPaths.OutboundProvisionPaths.getGroupGroupDN(this.index), channelSource.getGroupSourceLocation().getGroupDN()));
        }
        if (channelSource.getAccountManagementSettings() != null) {
            this.addValidator((Validator)new AccountManagementSettingsValidator(this.index, channelSource.getAccountManagementSettings(), this.ldapDataSource.getLdapType()));
        }
        if (channelSource.getGroupMembershipDetection() != null) {
            this.addValidator((Validator)new GroupMembershipDetectionValidation(this.index, this.ldapDataSource.getLdapType(), channelSource.getGroupMembershipDetection()));
        }
    }
}

