/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.IdentityHintContract;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.CibaRequestPolicyPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.ValidationUtil;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.OOBAuthPluginInstance;
import org.sourceid.saml20.domain.PersistentGrantAttribute;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceOneStarImpl;

public class CibaRequestHandlingPolicyValidator
extends BaseAttributeDataSourceValidator {
    private String id;
    private String name;
    private String pluginId;
    private String pcvId;
    private String transactionLifeInSeconds;
    private static final int TRANSACTION_LIFETIME_MIN_VALUE = 1;
    private static final int TRANSACTION_LIFETIME_MAX_VALUE = 3600;
    private boolean createMode;
    List<AltLoginHintTokenIssuer> altLoginHintTokenIssuers = new ArrayList<AltLoginHintTokenIssuer>();
    private IdentityHintContract identityHintContract;
    private AttributeMapping identityHintContractFulfillment;
    private AttributeMapping identityHintMapping;
    private static final String DEFAULT_POLICY_ID = "default";
    private boolean includeAttributMappingValidation = false;

    public CibaRequestHandlingPolicyValidator(Builder builder) {
        super(builder.context);
        this.id = builder.id;
        this.name = builder.name;
        this.pluginId = builder.pluginId;
        this.pcvId = builder.pcvId;
        this.transactionLifeInSeconds = builder.transactionLifeInSeconds;
        this.createMode = builder.isCreateMode;
        this.altLoginHintTokenIssuers = builder.altLoginHintTokenIssuers;
        this.identityHintContract = builder.identityHintContract;
        this.identityHintContractFulfillment = builder.identityHintContractFulfillment;
        this.identityHintMapping = builder.identityHintMapping;
        this.includeAttributMappingValidation = builder.includeAttributeMappingValidation;
        if (this.includeAttributMappingValidation) {
            if (this.identityHintContractFulfillment != null) {
                HashSet<String> validAttributeNamesERHCM = new HashSet<String>(this.identityHintContract.getAllAttributeNames());
                Set<String> coreSubstitutionVariablesERHCM = this.geIdentityHintMappingtDSFilterValues();
                HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSourcesERHCM = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                rootSourcesERHCM.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeForContractFulfillmentBuilder());
                rootSourcesERHCM.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
                rootSourcesERHCM.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
                rootSourcesERHCM.put(new SourceTypeIdKey(SourceType.REQUEST), this.createRequestTypeBuilder(new HashSet<String>(this.identityHintContract.getAllAttributeNames())));
                ExpressionManager expressionManagerERHCM = ExpressionManager.getInstance();
                if (expressionManagerERHCM.isEvaluateExpressionsOn()) {
                    rootSourcesERHCM.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
                }
                HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSourcesERHCM = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                validSourcesERHCM.putAll(rootSourcesERHCM);
                this.mapDataStoreTypesToDsValidators(this.identityHintContractFulfillment, validSourcesERHCM);
                this.addValidator((Validator)new AttributeMappingValidator(this.identityHintContractFulfillment, validAttributeNamesERHCM, coreSubstitutionVariablesERHCM, "request", validSourcesERHCM, CibaRequestPolicyPaths.getIdentityHintContractFulfillment(), this.getContext()));
            }
            if (this.identityHintMapping == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_hint_contract_to_oob_auth_plugin_mapping_required, CibaRequestPolicyPaths.getIdentityHintMapping()));
            } else {
                Set<String> validAttributeNames = this.getAllAttributeNamesNeededForHintContractToOOBAuthPluginMapping();
                Set<String> coreSubstitutionVariables = this.getDSFilterValues();
                HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeForContractMappingBuilder());
                rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
                rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
                rootSources.put(new SourceTypeIdKey(SourceType.REQUEST), this.createRequestTypeBuilder(new HashSet<String>(this.identityHintContract.getAllAttributeNames())));
                ExpressionManager expressionManager = ExpressionManager.getInstance();
                if (expressionManager.isEvaluateExpressionsOn()) {
                    rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
                }
                HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                validSources.putAll(rootSources);
                this.mapDataStoreTypesToDsValidators(this.identityHintMapping, validSources);
                this.addValidator((Validator)new AttributeMappingValidator(this.identityHintMapping, validAttributeNames, coreSubstitutionVariables, "request", validSources, CibaRequestPolicyPaths.getIdentityHintMapping(), this.getContext()));
            }
        }
    }

    @Override
    public boolean validate() {
        this.validatePolicyId();
        this.validatePolicyName();
        this.validateOOBPluginId();
        this.validatePcvId();
        this.validateTransactionLifeInSeconds();
        this.validateAltLoginHintTokenIssuers();
        this.validateRequestHintContract();
        super.validate();
        if (this.includeAttributMappingValidation && !this.hasErrors()) {
            this.validateIdentityHintContractMapping();
        }
        return !this.hasErrors();
    }

    private void validateIdentityHintContractMapping() {
        if (this.identityHintContractFulfillment == null) {
            return;
        }
        for (Map.Entry<String, AttributeFulfillmentValue> entry : this.identityHintContractFulfillment.getAttributeContractFulfillment().entrySet()) {
            if (entry.getValue().getSource().getType() != SourceType.REQUEST || entry.getKey().equals(entry.getValue().getValue())) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_identity_hint_contract_mapping_attribute_mapping_value_invalid, CibaRequestPolicyPaths.getIdentityHintContractFulfillment(), new Object[]{entry.getKey()}));
        }
    }

    private void validateRequestHintContract() {
        if (this.identityHintContract == null) {
            return;
        }
        UniqueEntriesValidator.UniqueKeyGetter<String> reqHintContractUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

            @Override
            public String getKey(String object) {
                return object;
            }
        };
        int index = 0;
        for (String contractAttribute : this.identityHintContract.getAllAttributeNames()) {
            if (StringUtils.isBlank((String)contractAttribute)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_request_hint_attribute_contract_empty_entry, CibaRequestPolicyPaths.getExtendedAttribute(index)));
            }
            ++index;
        }
        UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(reqHintContractUniqueKeyGetter, this.identityHintContract.getAllAttributeNames(), CibaRequestPolicyPaths.getExtendedAttributes(), ApiMessageKey.ciba_policy_request_hint_attribute_contract_duplicate_entry);
        uniqueEntriesValidator.setIgnoreNullEntries(true);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }

    private void validateAltLoginHintTokenIssuers() {
        if (this.altLoginHintTokenIssuers != null && !this.altLoginHintTokenIssuers.isEmpty()) {
            List issuers = this.altLoginHintTokenIssuers.stream().map(altI -> altI.issuer).collect(Collectors.toList());
            int index = 0;
            for (String issuer : issuers) {
                if (StringUtils.isBlank((String)issuer)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_issuer_required, CibaRequestPolicyPaths.getIssuer(index)));
                }
                ++index;
            }
            UniqueEntriesValidator.UniqueKeyGetter<String> attributeRuleUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

                @Override
                public String getKey(String object) {
                    return object;
                }
            };
            UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(attributeRuleUniqueKeyGetter, issuers, CibaRequestPolicyPaths.getIssuer(), ApiMessageKey.ciba_policy_issuer_duplicate);
            uniqueEntriesValidator.setIgnoreNullEntries(true);
            uniqueEntriesValidator.validate();
            this.appendErrors(uniqueEntriesValidator.getErrors());
            int index1 = 0;
            for (AltLoginHintTokenIssuer altLoginHintTokenIssuer : this.altLoginHintTokenIssuers) {
                this.validateAltLoginHintTokenIssuer(index1, altLoginHintTokenIssuer.jwksUrl, altLoginHintTokenIssuer.jwks);
                ++index1;
            }
        }
    }

    private void validateAltLoginHintTokenIssuer(int index, String jwksUrl, String jwks) {
        if (StringUtils.isNotBlank((String)jwksUrl) && StringUtils.isNotBlank((String)jwks)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_jwskUrl_exclusive_or_jwks, CibaRequestPolicyPaths.getJwks(index)));
        }
        if (StringUtils.isBlank((String)jwksUrl) && StringUtils.isBlank((String)jwks)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_jwskUrl_or_jwks_required, CibaRequestPolicyPaths.getJwks(index)));
        } else if (StringUtils.isNotBlank((String)jwksUrl) && StringUtils.isBlank((String)jwks)) {
            UrlMatchingServiceOneStarImpl urlMatcher = new UrlMatchingServiceOneStarImpl();
            if (!urlMatcher.isValidUrlPattern(jwksUrl)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_jwskUrl_malformed, CibaRequestPolicyPaths.getJwksUrl(index)));
            }
        } else if (StringUtils.isBlank((String)jwksUrl) && StringUtils.isNotBlank((String)jwks)) {
            try {
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jwks);
                List keys = jsonWebKeySet.getJsonWebKeys();
                if (keys == null || keys.isEmpty()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_jwks_invalid, CibaRequestPolicyPaths.getJwks(index)));
                }
            }
            catch (ClassCastException | JoseException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_jwks_invalid, CibaRequestPolicyPaths.getJwks(index)));
            }
        }
    }

    private void validateTransactionLifeInSeconds() {
        if (!ValidationUtil.isValidInt((String)this.transactionLifeInSeconds, (int)1, (int)3600)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_transaction_lifetime_invalid, CibaRequestPolicyPaths.getTransactionLifeInSeconds(), new Object[]{1, 3600}));
        }
    }

    private void validatePcvId() {
        if (StringUtils.isNotBlank((String)this.pcvId) && MgmtFactory.getCredentialValidatorManager().getInstance(this.pcvId) == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_pcv_not_found, CibaRequestPolicyPaths.getUserCodePcvId(), new Object[]{this.pcvId}));
        }
    }

    private void validateOOBPluginId() {
        if (StringUtils.isBlank((String)this.pluginId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_plugin_id_required, CibaRequestPolicyPaths.getPolicyId()));
        } else if (MgmtFactory.getOOBAuthPluginManager().getInstance(this.pluginId) == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_oob_plugin_not_found, CibaRequestPolicyPaths.getOOBPluginId(), new Object[]{this.pluginId}));
        }
    }

    private void validatePolicyName() {
        if (StringUtils.isBlank((String)this.name)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_name_required, CibaRequestPolicyPaths.getPolicyName()));
        } else if (this.isCreateMode() && this.policyNameExists()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_name_in_use, CibaRequestPolicyPaths.getPolicyName()));
        }
    }

    private boolean policyNameExists() {
        Map policies = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy().getRequestHandlingPolicies();
        for (CibaServerPolicy.RequestHandlingPolicy existingPolicy : policies.values()) {
            if (!existingPolicy.getName().equals(this.name)) continue;
            return true;
        }
        return false;
    }

    private void validatePolicyId() {
        if (StringUtils.isBlank((String)this.id)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_id_required, CibaRequestPolicyPaths.getPolicyId()));
        } else if (DEFAULT_POLICY_ID.equalsIgnoreCase(this.id)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_default_invalid, CibaRequestPolicyPaths.getPolicyId(), new Object[]{this.id, "ID"}));
        } else if (DEFAULT_POLICY_ID.equalsIgnoreCase(this.name)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_default_invalid, CibaRequestPolicyPaths.getPolicyName(), new Object[]{this.name, "Name"}));
        } else if (this.isCreateMode()) {
            if (this.policyIdExists()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_policy_id_in_use, CibaRequestPolicyPaths.getPolicyId()));
            }
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 33, CibaRequestPolicyPaths.getPolicyId()));
        }
    }

    private boolean policyIdExists() {
        Map policies = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy().getRequestHandlingPolicies();
        for (String existingPolicyId : policies.keySet()) {
            if (!existingPolicyId.equals(this.id)) continue;
            return true;
        }
        return false;
    }

    private boolean isCreateMode() {
        return this.createMode;
    }

    private ContextSourceTypeValidatorBuilder createContextTypeForContractFulfillmentBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForPluginContracts());
        return builder;
    }

    private ContextSourceTypeValidatorBuilder createContextTypeForContractMappingBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForCibaRequestMappings());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private AttributeSetSourceTypeValidatorBuilder createRequestTypeBuilder(Set<String> requestHintContract) {
        return new AttributeSetSourceTypeValidatorBuilder(requestHintContract, SourceType.REQUEST);
    }

    private Set<String> getAllAttributeNamesNeededForHintContractToOOBAuthPluginMapping() {
        HashSet<String> attributes = new HashSet<String>();
        attributes.add("USER_KEY");
        if (this.pluginId != null && MgmtFactory.getOOBAuthPluginManager().getInstance(this.pluginId) != null) {
            attributes.addAll(((OOBAuthPluginInstance)MgmtFactory.getOOBAuthPluginManager().getInstance(this.pluginId)).getAttributeContract().getAllAttributeNames());
        }
        if (this.pcvId != null) {
            attributes.add("USER_CODE_USER_NAME");
        }
        List persistentGrantAttributes = MgmtFactory.getAuthzServerManager().getPersistentGrantExtendedAttributes();
        for (PersistentGrantAttribute persistentGrantAttribute : persistentGrantAttributes) {
            attributes.add(persistentGrantAttribute.getName());
        }
        return attributes;
    }

    private Set<String> geIdentityHintMappingtDSFilterValues() {
        ArrayList<String> validValues = new ArrayList<String>();
        validValues.add("IDENTITY_HINT_SUBJECT");
        if (this.identityHintContract != null && !this.identityHintContract.getAllAttributeNames().isEmpty()) {
            for (String hintContractAttribute : this.identityHintContract.getAllAttributeNames()) {
                if (hintContractAttribute == null || !hintContractAttribute.equals("login_hint") && !hintContractAttribute.startsWith("login_hint_token.") && !hintContractAttribute.startsWith("id_token_hint.") && !hintContractAttribute.startsWith("request.")) continue;
                validValues.add(hintContractAttribute);
            }
        }
        return new HashSet<String>(validValues);
    }

    private Set<String> getDSFilterValues() {
        return new HashSet<String>(this.identityHintContract.getAllAttributeNames());
    }

    public static class Builder {
        private String id;
        private String name;
        private String pluginId;
        private String pcvId;
        private String transactionLifeInSeconds;
        private List<AltLoginHintTokenIssuer> altLoginHintTokenIssuers;
        private IdentityHintContract identityHintContract;
        private AttributeMapping identityHintContractFulfillment;
        private AttributeMapping identityHintMapping;
        private ValidatorContext context;
        private boolean isCreateMode;
        private boolean includeAttributeMappingValidation;

        public Builder setId(String policyId) {
            this.id = policyId;
            return this;
        }

        public Builder setName(String policyName) {
            this.name = policyName;
            return this;
        }

        public Builder setPluginId(String oobPluginId) {
            this.pluginId = oobPluginId;
            return this;
        }

        public Builder setPcvId(String pcvId) {
            this.pcvId = pcvId;
            return this;
        }

        public Builder setTransactionLifeInSeconds(String transactionLifeInSeconds) {
            this.transactionLifeInSeconds = transactionLifeInSeconds;
            return this;
        }

        public Builder setIsCreateMode(boolean isCreateMode) {
            this.isCreateMode = isCreateMode;
            return this;
        }

        public Builder setAltLoginHintTokenIssuers(List<AltLoginHintTokenIssuer> altLoginHintTokenIssuers) {
            this.altLoginHintTokenIssuers = altLoginHintTokenIssuers;
            return this;
        }

        public Builder setIdentityHintContract(IdentityHintContract identityHintContract) {
            this.identityHintContract = identityHintContract;
            return this;
        }

        public Builder setIdentityHintContractFulfillment(AttributeMapping identityHintContractFulfillment) {
            this.identityHintContractFulfillment = identityHintContractFulfillment;
            return this;
        }

        public Builder setIdentityHintMapping(AttributeMapping identityHintMapping) {
            this.identityHintMapping = identityHintMapping;
            return this;
        }

        public Builder setIncludeAttributeMappingValidation(boolean includeAttributeMappingValidation) {
            this.includeAttributeMappingValidation = includeAttributeMappingValidation;
            return this;
        }

        public Builder setContext(ValidatorContext context) {
            this.context = context;
            return this;
        }

        public CibaRequestHandlingPolicyValidator build() {
            return new CibaRequestHandlingPolicyValidator(this);
        }
    }

    public static class AltLoginHintTokenIssuer {
        private String issuer;
        private String jwksUrl;
        private String jwks;

        public AltLoginHintTokenIssuer(String issuer, String jwksUrl, String jwks) {
            this.issuer = issuer;
            this.jwksUrl = jwksUrl;
            this.jwks = jwks;
        }
    }
}

