/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConditionType;

public class ConditionalIssuanceCriteriaEntryValidator
extends CompositeValidator {
    private final String attributeName;
    private final ConditionType condition;
    private final String expectedValue;
    private final String fieldPath;

    public ConditionalIssuanceCriteriaEntryValidator(Validator sourceTypeValidator, ConditionalIssuanceCriteriaEntry icEntry, String fieldPath) {
        this.attributeName = icEntry.getAttributeName();
        this.condition = icEntry.getCondition();
        this.expectedValue = icEntry.getValue();
        this.fieldPath = fieldPath;
        this.addValidator(sourceTypeValidator);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isBlank((String)this.attributeName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_attribute_name_required, ConnectionPaths.getConditionalIssuanceCriteriaAttrNamePath(this.fieldPath)));
        } else {
            super.validate();
        }
        if (this.condition == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_condition_required, ConnectionPaths.getConditionalIssuanceCriteriaConditionPath(this.fieldPath)));
        }
        if (StringUtils.isBlank((String)this.expectedValue)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.issuance_criteria_value_required, ConnectionPaths.getConditionalIssuanceCriteriaValuePath(this.fieldPath)));
        }
        return !this.hasErrors();
    }
}

