/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.ApiMessages;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.upgrade.Utils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.zip.UnzipUtil;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.domain.mgmt.impl.DataDeployer;

public class ConfigArchiveValidator
extends AbstractValidator {
    private final InputStream inputStream;
    protected transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<String, byte[]> archiveMap = new HashMap<String, byte[]>();
    private boolean hasVersionError = false;
    private ValidationError versionError;

    public ConfigArchiveValidator(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean validate() {
        try {
            this.archiveMap = UnzipUtil.unzip((InputStream)this.inputStream);
            if (this.archiveMap == null || this.archiveMap.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_archive_not_a_zip, null));
            } else if (!new DataDeployer().isValidArchive(this.archiveMap)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_archive_invalid, null));
            } else {
                this.validateArchiveVersion();
            }
        }
        catch (IOException io) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_archive_unexpected_error_full, ""));
            this.log.debug((Object)(ApiMessages.getMessage(ApiMessageKey.config_archive_unexpected_error.getMsgKey()) + io));
        }
        return !this.hasErrors();
    }

    public Map<String, byte[]> getArchiveMap() {
        return this.hasErrors() ? Collections.EMPTY_MAP : this.archiveMap;
    }

    private void validateArchiveVersion() {
        String archiveVersion = Utils.getVersionFromConfigArchive(this.archiveMap);
        if (!"Unknown".equals(archiveVersion)) {
            int comparisonResult = VersionUtil.compareProductMajorMinorVersions((String)PropertyInfo.getPingFederateVersion(), (String)archiveVersion);
            if (comparisonResult == 1) {
                this.hasVersionError = true;
                this.versionError = ValidationErrorFactory.getInstance().create(ApiMessageKey.config_archive_version_lesser, null);
            } else if (comparisonResult == -1) {
                this.hasVersionError = true;
                this.versionError = ValidationErrorFactory.getInstance().create(ApiMessageKey.config_archive_version_greater, null);
            }
        } else {
            this.hasVersionError = true;
            this.versionError = ValidationErrorFactory.getInstance().create(ApiMessageKey.config_archive_version_lesser, null);
        }
    }

    public boolean hasVersionError() {
        return this.hasVersionError;
    }

    public ValidationError getVersionError() {
        return this.versionError;
    }
}

