/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.bulkconfig.ConfigStrategy;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperation;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperationType;
import com.pingidentity.admin.api.model.fieldpaths.BulkConfigPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;

public class ConfigOperationValidator
extends AbstractValidator {
    private ConfigOperation operation;
    private int operationIndex;
    private ConfigStrategy configStrategy;

    public ConfigOperationValidator(ConfigOperation operation, int operationIndex, ConfigStrategy configStrategy) {
        this.operation = operation;
        this.operationIndex = operationIndex;
        this.configStrategy = configStrategy;
    }

    public boolean validate() {
        ValidationError error;
        if (this.operation.getOperationType() == ConfigOperationType.SAVE && this.operation.getItemIds() != null) {
            error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_item_ids_not_expected, BulkConfigPaths.getOperationItemIds(this.operationIndex));
            this.appendError(error);
        }
        if (this.operation.getOperationType() == ConfigOperationType.DELETE && this.operation.getItems() != null) {
            error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_items_not_expected, BulkConfigPaths.getOperationItems(this.operationIndex));
            this.appendError(error);
        }
        if (this.operation.getOperationType() == ConfigOperationType.DELETE && !this.configStrategy.isDeleteSupported()) {
            error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_delete_not_supported, BulkConfigPaths.getOperationResourceType(this.operationIndex), new Object[]{this.operation.getResourceType()});
            this.appendError(error);
        }
        if (this.operation.getSubResource() != null && !this.configStrategy.hasSubResources()) {
            error = ValidationErrorFactory.getInstance().create(ApiMessageKey.bulk_config_subresource_not_supported, BulkConfigPaths.getOperationResourceType(this.operationIndex), new Object[]{this.operation.getResourceType()});
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

