/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConfigStoreSetting;
import com.pingidentity.admin.api.model.fieldpaths.ConfigStorePaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import java.util.Map;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class ConfigStoreValidator
extends AbstractValidator {
    private String bundle;
    private ConfigStoreSetting setting;
    private ConfigStore store;

    public ConfigStoreValidator(String bundle) {
        this.bundle = bundle;
    }

    public ConfigStoreValidator(String bundle, ConfigStoreSetting setting, ConfigStore store) {
        this(bundle);
        this.store = store;
        this.setting = setting;
    }

    public boolean validate() {
        if (this.setting != null) {
            String id = this.setting.getId();
            String strValue = this.setting.getStringValue();
            List<String> listValue = this.setting.getListValue();
            Map<String, String> mapValue = this.setting.getMapValue();
            ConfigStoreSetting.Type type = this.setting.getType();
            int count = 0;
            if (strValue != null) {
                ++count;
            }
            if (listValue != null) {
                ++count;
            }
            if (mapValue != null) {
                ++count;
            }
            if (count == 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_value_required, null));
            } else if (count > 1) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_multiple_setting_values, null));
            } else if (type == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_type_required, ConfigStorePaths.getType()));
            } else {
                switch (type) {
                    case STRING: {
                        if (strValue == null) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_type_value_mismatch, ConfigStorePaths.getType()));
                            break;
                        }
                        if (this.store.isListValue(id)) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_existing_type_mismatch, ConfigStorePaths.getType(), new Object[]{type.toString(), "LIST"}));
                            break;
                        }
                        if (!this.store.isMapValue(id)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_existing_type_mismatch, ConfigStorePaths.getType(), new Object[]{type.toString(), "MAP"}));
                        break;
                    }
                    case LIST: {
                        if (listValue == null) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_type_value_mismatch, ConfigStorePaths.getType()));
                            break;
                        }
                        if (this.store.isMapValue(id)) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_existing_type_mismatch, ConfigStorePaths.getType(), new Object[]{type.toString(), "MAP"}));
                            break;
                        }
                        if (!this.store.getKeys().contains(id) || this.store.isListValue(id)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_existing_type_mismatch, ConfigStorePaths.getType(), new Object[]{type.toString(), "STRING"}));
                        break;
                    }
                    case MAP: {
                        if (mapValue == null) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_type_value_mismatch, ConfigStorePaths.getType()));
                            break;
                        }
                        if (this.store.isListValue(id)) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_existing_type_mismatch, ConfigStorePaths.getType(), new Object[]{type.toString(), "LIST"}));
                            break;
                        }
                        if (!this.store.getKeys().contains(id) || this.store.isMapValue(id)) break;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.config_store_setting_existing_type_mismatch, ConfigStorePaths.getType(), new Object[]{type.toString(), "STRING"}));
                    }
                }
            }
        }
        return !this.hasErrors();
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isBundleInApiDenySet() {
        return ConfigStoreFarm.isInApiDenySet((String)this.bundle);
    }
}

