/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ConnectionMetadataUrlValidator;
import com.pingidentity.admin.api.validator.ExtendedPropertyValueValidator;
import com.pingidentity.admin.api.validator.GeneralInfoValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.LicenseConnectionValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.admin.rest.translator.ExtendedPropertyValuesTranslator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConnectionBaseValidator
extends CompositeValidator {
    private String id;
    private boolean isUpdate;
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private ExtendedPropertyValuesTranslator extendedPropertyTranslator = new ExtendedPropertyValuesTranslator();

    public ConnectionBaseValidator(boolean isUpdate, final ConnectionBase existingConn, final Connection connection) {
        this.id = connection.getId();
        this.isUpdate = isUpdate;
        if (!isUpdate && this.id != null) {
            this.addValidator((Validator)new IdValidator(this.id, true, false, 0, 33, ConnectionPaths.getConnectionId()));
        }
        this.addValidator((Validator)new GeneralInfoValidator(connection));
        this.addValidator((Validator)new AbstractValidator(){

            public boolean validate() {
                this.appendErrors(LicenseConnectionValidator.getInstance().validate(existingConn, connection.getLicenseConnectionGroup(), true, false));
                return !this.hasErrors();
            }
        });
        this.addValidator((Validator)new ConnectionMetadataUrlValidator(connection));
        ExtendedPropertyValueValidator extParamValidator = new ExtendedPropertyValueValidator(this.extendedPropertyTranslator.apiTodomain(connection.getExtendedProperties()), true);
        this.addValidator((Validator)extParamValidator);
    }

    public void checkSpConnectionIdDuplicate() {
        if (!this.isUpdate && this.connectionManager.getSpConnectionBySystemId(this.id) != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sp_connection_id_duplicate, ConnectionPaths.getConnectionId()));
        }
    }

    public void checkIdpConnectionIdDuplicate() {
        if (!this.isUpdate && this.connectionManager.getIdpConnectionBySystemId(this.id) != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_connection_id_duplicate, ConnectionPaths.getConnectionId()));
        }
    }
}

