/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.connmetadata.ConvertMetadataRequest;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionMetadataPaths;
import com.pingidentity.admin.api.validator.CertificateValidator;
import com.pingidentity.admin.api.validator.MetadataValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.B64;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.impl.MetadataUpdateTaskHelper;
import org.sourceid.saml20.domain.util.MetadataImportException;

public class ConnectionMetadataRequestValidator
extends AbstractValidator {
    private final ConvertMetadataRequest metadataRequest;
    private ConnectionBase domainConn = null;
    private XmlSignatureVerifier sigVerifier = null;

    public ConnectionMetadataRequestValidator(ConvertMetadataRequest metadataRequest) {
        this.metadataRequest = metadataRequest;
    }

    public boolean validate() {
        String expectedEntityId;
        String templateEntityId = null;
        ConnectionType connectionType = this.metadataRequest.getConnectionType();
        if (connectionType == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_connection_type_required, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getConnectionType()));
        } else {
            Connection templateConnection = this.metadataRequest.getTemplateConnection();
            if (templateConnection != null) {
                if (templateConnection.getType() != null && connectionType != templateConnection.getType()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_wrong_template_connection, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getTemplateConnection(), new Object[]{connectionType.getLabel()}));
                } else {
                    templateEntityId = templateConnection.getEntityId();
                }
            }
        }
        if (this.metadataRequest.getExpectedProtocol() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_expected_protocol_required, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getExpectedProtocol()));
        }
        ByteArrayInputStream metadataStream = null;
        if (this.metadataRequest.getSamlMetadata() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_saml_metadata_required, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getSamlMetadata()));
        } else {
            try {
                metadataStream = new ByteArrayInputStream(B64.decodeToString((String)this.metadataRequest.getSamlMetadata()).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        Cert cert = null;
        if (this.metadataRequest.getVerificationCertificate() != null) {
            CertificateValidator validator = new CertificateValidator(this.metadataRequest.getVerificationCertificate(), ConnectionMetadataPaths.ConvertMetadataRequestPaths.getVerificationCertificate());
            if (validator.validate()) {
                cert = validator.getCert();
            } else {
                this.appendErrors(validator.getErrors());
            }
        }
        if ((expectedEntityId = this.metadataRequest.getExpectedEntityId()) == null) {
            expectedEntityId = templateEntityId;
        } else if (templateEntityId != null && !expectedEntityId.equals(templateEntityId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_mismatched_entity_id, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getExpectedEntityId(), new Object[]{expectedEntityId, templateEntityId}));
        }
        if (!this.hasErrors()) {
            MetadataValidator mdValidator = new MetadataValidator(connectionType.getImportExpectedConnectionType(), this.metadataRequest.getExpectedProtocol().getDomainProtocol(), metadataStream, true, cert, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getSamlMetadata(), ConnectionMetadataPaths.ConvertMetadataRequestPaths.getVerificationCertificate());
            if (mdValidator.validate()) {
                Collection<ConnectionBase> importedConnections = mdValidator.getImportedConnectionsList();
                this.domainConn = this.getConnection(templateEntityId, connectionType, expectedEntityId, importedConnections);
                this.sigVerifier = mdValidator.getSigVerifier();
            } else {
                this.appendErrors(mdValidator.getErrors());
            }
        }
        return !this.hasErrors();
    }

    private ConnectionBase getConnection(String templateEntityId, ConnectionType connectionType, String expectedEntityId, Collection<ConnectionBase> importedConnections) {
        if (importedConnections == null || importedConnections.isEmpty()) {
            return null;
        }
        ConnectionBase connection = null;
        int connectionCount = importedConnections.size();
        if (expectedEntityId == null) {
            if (connectionCount == 1) {
                connection = importedConnections.iterator().next();
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_entity_id_required, ConnectionMetadataPaths.ConvertMetadataRequestPaths.getExpectedEntityId()));
            }
        } else {
            connection = this.getConnectionWithEntityId(templateEntityId, connectionType, expectedEntityId, importedConnections, connection);
        }
        if (connection != null && connection.getEncryptionSettings() != null && connection.getEncryptionSettings().getEncryptionPolicy() != null) {
            connection.getEncryptionSettings().getEncryptionPolicy().setKeyTransportAlgorithm(null);
            connection.getEncryptionSettings().getEncryptionPolicy().setEncryptionAlgorithm(null);
        }
        this.updateSamlProfileAndBindings(connection);
        return connection;
    }

    private void updateSamlProfileAndBindings(ConnectionBase connection) {
        if (connection != null) {
            Protocol apiProtocol = Protocol.valueOf(connection.getProtocol().name());
            if (Protocol.isSaml1x(apiProtocol)) {
                this.updateSaml1xBinding(connection);
            } else {
                this.updateSaml2xBinding(connection);
            }
            if (connection.getSingleLogoutServices() == null || connection.getSingleLogoutServices().getEndpoints() == null || connection.getSingleLogoutServices().getEndpoints().isEmpty()) {
                connection.getEnabledProfiles().setIdpInitiatedSLOEnabled(false);
                connection.getEnabledProfiles().setSpInitiatedSLOEnabled(false);
            } else {
                connection.getEnabledProfiles().setIdpInitiatedSLOEnabled(true);
                connection.getEnabledProfiles().setSpInitiatedSLOEnabled(true);
            }
            if (connection instanceof SpConnection) {
                SpConnection spConnection = (SpConnection)connection;
                if (spConnection.getAssertionConsumerServiceEndpoints() == null || spConnection.getAssertionConsumerServiceEndpoints().getEndpoints() == null || spConnection.getAssertionConsumerServiceEndpoints().getEndpoints().isEmpty()) {
                    connection.getEnabledProfiles().setSpInitiatedSSOEnabled(false);
                    connection.getEnabledProfiles().setIdpInitiatedSSOEnabled(false);
                } else {
                    connection.getEnabledProfiles().setSpInitiatedSSOEnabled(true);
                    connection.getEnabledProfiles().setIdpInitiatedSSOEnabled(true);
                }
            } else {
                IdpConnection idpConnection = (IdpConnection)connection;
                if (idpConnection.getSingleSignOnServices() == null || idpConnection.getSingleSignOnServices().getEndpoints() == null || idpConnection.getSingleSignOnServices().getEndpoints().isEmpty()) {
                    connection.getEnabledProfiles().setSpInitiatedSSOEnabled(false);
                    connection.getEnabledProfiles().setIdpInitiatedSSOEnabled(false);
                } else {
                    connection.getEnabledProfiles().setSpInitiatedSSOEnabled(true);
                }
            }
        }
    }

    private void updateSaml2xBinding(ConnectionBase connection) {
        connection.getIncomingBindings().setPostBinding(true);
        connection.getIncomingBindings().setRedirectBinding(true);
        connection.getIncomingBindings().setArtifactBinding(false);
        if (connection.isArtifactSsoSloUsed()) {
            connection.getIncomingBindings().setSoapBinding(true);
        } else {
            connection.getIncomingBindings().setSoapBinding(false);
        }
    }

    private void updateSaml1xBinding(ConnectionBase connection) {
        connection.getIncomingBindings().setPostBinding(true);
        connection.getIncomingBindings().setArtifactBinding(true);
        connection.getIncomingBindings().setSoapBinding(false);
        connection.getIncomingBindings().setRedirectBinding(false);
    }

    private ConnectionBase getConnectionWithEntityId(String templateEntityId, ConnectionType connectionType, String expectedEntityId, Collection<ConnectionBase> importedConnections, ConnectionBase connection) {
        try {
            connection = MetadataUpdateTaskHelper.getConnectionWithEntityId((String)expectedEntityId, importedConnections);
        }
        catch (MetadataImportException e) {
            String errorPath = null;
            errorPath = templateEntityId != null ? ConnectionMetadataPaths.ConvertMetadataRequestPaths.getTemplateConnectionEntityId() : ConnectionMetadataPaths.ConvertMetadataRequestPaths.getExpectedEntityId();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.conn_metadata_invalid_entity_id, errorPath, new Object[]{connectionType.getLabel(), expectedEntityId}));
        }
        return connection;
    }

    public ConnectionBase getDomainConnection() {
        return this.domainConn;
    }

    public XmlSignatureVerifier getSigVerifier() {
        return this.sigVerifier;
    }
}

