/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SigningSettings;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.CredentialsPath;
import com.pingidentity.admin.api.validator.BaseSigningSettingsValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.SigningSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class ConnectionSigningSettingsValidator
extends CompositeValidator {
    private Protocol protocol = null;
    private boolean signOutgoingAssertions;
    private final ConnectionCredentials connCreds;
    private final Role role;
    private final Connection connection;
    private boolean fullValidationPath;

    public ConnectionSigningSettingsValidator(IdpConnection connection, boolean fullValidationPath) {
        if (connection.getIdpBrowserSso() != null) {
            this.signOutgoingAssertions = connection.getIdpBrowserSso().isSignAuthnRequests() == null ? false : connection.getIdpBrowserSso().isSignAuthnRequests();
            this.protocol = connection.getIdpBrowserSso().getProtocol();
        }
        this.connCreds = connection.getCredentials();
        this.role = connection.getType().getRole();
        this.connection = connection;
        this.fullValidationPath = fullValidationPath;
    }

    public ConnectionSigningSettingsValidator(SpConnection connection, boolean fullValidationPath) {
        if (connection.getSpBrowserSso() != null) {
            this.signOutgoingAssertions = connection.getSpBrowserSso().isSignAssertions() == null ? false : connection.getSpBrowserSso().isSignAssertions();
            this.protocol = connection.getSpBrowserSso().getProtocol();
        }
        this.connCreds = connection.getCredentials();
        this.role = connection.getType().getRole();
        this.connection = connection;
        this.fullValidationPath = fullValidationPath;
    }

    private boolean requireSpDigitalSigning() {
        SpConnection conn = (SpConnection)this.connection;
        SpBrowserSso browserSso = conn.getSpBrowserSso();
        boolean ssoSelected = false;
        boolean acsPost = false;
        boolean acsRedirect = false;
        boolean sloPost = false;
        boolean sloRedirect = false;
        boolean xasp = false;
        boolean wsfed = this.protocol == Protocol.WSFED;
        boolean wstrust = conn.getWsTrust() != null;
        boolean inboundArtifactDsig = false;
        if (browserSso != null) {
            ssoSelected = browserSso.isAnySsoSelected();
            acsPost = browserSso.isBindingSsoUsed(Binding.POST);
            acsRedirect = browserSso.isBindingSsoUsed(Binding.REDIRECT);
            sloPost = browserSso.isBindingSloUsed(Binding.POST);
            sloRedirect = browserSso.isBindingSloUsed(Binding.REDIRECT);
        }
        if (conn.getCredentials() != null && conn.getCredentials().getOutboundBackChannelAuth() != null) {
            inboundArtifactDsig = conn.getCredentials().getOutboundBackChannelAuth().isDigitalSignature();
        }
        if (conn.getAttributeQuery() != null) {
            xasp = conn.getAttributeQuery().getPolicy().isSignResponse() || conn.getAttributeQuery().getPolicy().isSignAssertion();
        }
        return ssoSelected && (acsPost || acsRedirect || sloPost || sloRedirect || this.signOutgoingAssertions) || xasp || wsfed || wstrust || inboundArtifactDsig;
    }

    private boolean requireIdpDigitalSigning() {
        IdpConnection conn = (IdpConnection)this.connection;
        IdpBrowserSso browserSso = conn.getIdpBrowserSso();
        ConnectionCredentials credentials = conn.getCredentials();
        boolean ssoSelected = false;
        boolean sloPost = false;
        boolean sloRedirect = false;
        boolean xasp = false;
        boolean inboundArtifactDsig = false;
        if (browserSso != null) {
            ssoSelected = browserSso.isAnySsoSelected();
            sloPost = browserSso.isBindingSloUsed(Binding.POST);
            sloRedirect = browserSso.isBindingSloUsed(Binding.REDIRECT);
        }
        if (credentials != null && credentials.getOutboundBackChannelAuth() != null) {
            inboundArtifactDsig = credentials.getOutboundBackChannelAuth().isDigitalSignature();
        }
        if (conn.getAttributeQuery() != null) {
            xasp = conn.getAttributeQuery().getPolicy().isSignAttributeQuery();
        }
        return ssoSelected && (sloPost || sloRedirect || this.signOutgoingAssertions) || xasp || inboundArtifactDsig;
    }

    private boolean requireDigitalSigning() {
        if (this.role == Role.SP) {
            return this.requireSpDigitalSigning();
        }
        return this.requireIdpDigitalSigning();
    }

    @Override
    public boolean validate() {
        SpBrowserSso browserSso;
        WsFedTokenType tokenType = null;
        boolean signedCertRequired = this.requireDigitalSigning();
        if (signedCertRequired && this.protocol == Protocol.WSFED && this.connection.getBrowserSso() instanceof SpBrowserSso && (tokenType = (browserSso = (SpBrowserSso)this.connection.getBrowserSso()).getWsFedTokenType()) == WsFedTokenType.JWT) {
            PkCert pkCert;
            SigningSettings signingSettings = this.connCreds.getSigningSettings();
            if (this.connCreds.getSigningSettings() != null && signingSettings.getSigningKeyPairRef() != null && (pkCert = MgmtFactory.getDsigPkCertManager().getPkCert(signingSettings.getSigningKeyPairRef().getId())) != null) {
                String alg = pkCert.getPublicKeyAlgorithm();
                int keySize = pkCert.getPublicKeySize();
                if (!"RSA".equalsIgnoreCase(alg) && !"EC".equalsIgnoreCase(alg) || keySize < 2048) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.wsfed_key_ec_rsa_cert_restrictions, CredentialsPath.getSigningSettings(true)));
                }
                if (!signingSettings.getAlgorithm().startsWith(alg)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.wsfed_key_ec_rsa_cert_algorithm, CredentialsPath.getSigningSettings(true)));
                }
            }
        }
        if (this.connection.getBrowserSso() != null && this.connection.getBrowserSso() instanceof SpBrowserSso && this.protocol != null) {
            SpBrowserSso spBrowserSso = (SpBrowserSso)this.connection.getBrowserSso();
            if (!this.protocol.equals((Object)Protocol.SAML20) && spBrowserSso.isSignResponseAsRequired() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getSpBrowserSsoSignResponseAsRequired(), new Object[]{"signResponseAsRequired"}));
            }
            if (this.protocol.equals((Object)Protocol.SAML20) && !spBrowserSso.isSignAssertions().booleanValue() && !spBrowserSso.isSignResponseAsRequired().booleanValue()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.saml_signature_required, ConnectionPaths.getSpBrowserSsoSignResponseAsRequired()));
            }
        }
        boolean allowEmptyCert = !signedCertRequired;
        BaseSigningSettingsValidator baseSigningSettingsValidator = new BaseSigningSettingsValidator(this.connCreds.getSigningSettings(), allowEmptyCert, CredentialsPath.getSigningSettings(true), this.protocol, tokenType, this.fullValidationPath);
        baseSigningSettingsValidator.validate();
        this.appendErrors(baseSigningSettingsValidator.getErrors());
        SigningSettingsValidator signingSettingsValidator = new SigningSettingsValidator(MgmtFactory.getDSignRotationSettingsManager(), this.connCreds.getSigningSettings(), CredentialsPath.getSigningSettings(true));
        signingSettingsValidator.validate();
        this.appendErrors(signingSettingsValidator.getErrors());
        return !this.hasErrors();
    }
}

