/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.PluginFieldsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.sources.CustomDataSourceDriver;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CustomAttributeSourceFilterValidator
extends PluginFieldsValidator {
    private List<ConfigurationValidator> configValidationChain;
    private Configuration filterAndDataSourceConfig;
    private String fieldPath;

    public CustomAttributeSourceFilterValidator(List<Field> fields, String dataStoreId, String fieldPath) {
        CustomDataSource dataSource = MgmtFactory.getDataSourceManager().getCustomDataSource(dataStoreId);
        if (dataSource != null) {
            SourceDescriptor sourceDescriptor;
            CustomDataSourceDriver dsDriver = dataSource.getDriver();
            if (dsDriver == null) {
                MgmtFactory.getDataSourceManager().loadCustomDataSourceDriver(dataSource);
                dsDriver = dataSource.getDriver();
            }
            if ((sourceDescriptor = dsDriver.getSourceDescriptor()) instanceof CustomDataSourceDriverDescriptor) {
                CustomDataSourceDriverDescriptor descriptor = (CustomDataSourceDriverDescriptor)dsDriver.getSourceDescriptor();
                FilterFieldsGuiDescriptor filterFieldsDescriptor = descriptor.getFilterFieldsDescriptor();
                List fieldDescriptors = Collections.emptyList();
                if (filterFieldsDescriptor != null && filterFieldsDescriptor.getFields() != null) {
                    fieldDescriptors = filterFieldsDescriptor.getFields();
                }
                this.fieldDescriptors = fieldDescriptors;
                if (filterFieldsDescriptor != null) {
                    this.configValidationChain = filterFieldsDescriptor.getValidationChain();
                    this.fieldPath = fieldPath;
                    this.filterAndDataSourceConfig = dataSource.getConfiguration();
                    for (Field field : fields) {
                        this.filterAndDataSourceConfig.addField(field);
                    }
                }
            } else {
                this.fieldDescriptors = Collections.emptyList();
            }
            this.fields = fields;
            this.fieldsPath = fieldPath;
        } else {
            this.fields = Collections.emptyList();
            this.fieldDescriptors = Collections.emptyList();
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.configValidationChain != null) {
            for (ConfigurationValidator validator : this.configValidationChain) {
                try {
                    validator.validate(this.filterAndDataSourceConfig);
                }
                catch (ValidationException e) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.plugin_filter_field_error.getMsgKey(), e.getMessage(), this.fieldPath));
                }
            }
        }
        return !this.hasErrors();
    }
}

