/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.DSignRotationSettingsPaths;
import com.pingidentity.admin.api.validator.KeyRotationSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class DSignRotationSettingsValidator
extends KeyRotationSettingsValidator {
    private String activationBufferDaysStr;
    private Date originalCertExpiryDate;

    public DSignRotationSettingsValidator(String activationBufferDays, String creationBufferDays, String validDays, String keyAlgorithm, String keySize, String signatureAlgorithm, Date originalCertExpiryDate) {
        super(creationBufferDays, validDays, keyAlgorithm, keySize, signatureAlgorithm, "Creation");
        this.activationBufferDaysStr = activationBufferDays;
        this.originalCertExpiryDate = originalCertExpiryDate;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (StringUtils.isBlank((String)this.activationBufferDaysStr)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dsign_activation_buffer_required, null));
        } else {
            int rotationBufferDays = -1;
            int activationBufferDays = -1;
            try {
                activationBufferDays = Integer.parseInt(this.activationBufferDaysStr);
                rotationBufferDays = Integer.parseInt(this.getRotationBufferDaysStr());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (activationBufferDays <= 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dsign_activation_buffer_invalid, DSignRotationSettingsPaths.getActivationBufferDays(), new Object[]{1, this.getMaxRotationBufferDays()}));
            } else if (this.isCertExpiredBeforeRotation(rotationBufferDays)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dsign_certificate_expired_before_rotation, this.getRotationBufferPathName()));
            } else if (rotationBufferDays != -1 && activationBufferDays > rotationBufferDays) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dsign_activation_greater_than_rotation_buffer, DSignRotationSettingsPaths.getActivationBufferDays()));
            }
        }
        return this.getErrors().isEmpty();
    }

    private boolean isCertExpiredBeforeRotation(int rotationBufferDays) {
        Calendar originalCertCal = Calendar.getInstance();
        originalCertCal.setTime(this.originalCertExpiryDate);
        Calendar rotationBufferCal = Calendar.getInstance();
        rotationBufferCal.add(5, rotationBufferDays);
        boolean certInactiveBeforeRotation = originalCertCal.getTime().before(rotationBufferCal.getTime());
        if (certInactiveBeforeRotation) {
            return !this.isSameDay(originalCertCal, rotationBufferCal);
        }
        return certInactiveBeforeRotation;
    }

    private boolean isSameDay(Calendar original, Calendar rotation) {
        return original.get(1) == rotation.get(1) && original.get(6) == rotation.get(6);
    }

    @Override
    public String getRotationBufferPathName() {
        String rotationBufferPath = DSignRotationSettingsPaths.getCreationBufferDays();
        return rotationBufferPath;
    }
}

