/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.JdbcAttributeSource;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.DsSourceTypeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DsSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private AttributeSource attributeSource;
    private SourceType sourceType;
    private Set<String> expectedAttributes = null;
    private String attributeSourceDatastoreRefId;

    public DsSourceTypeValidatorBuilder() {
        this(null);
    }

    public DsSourceTypeValidatorBuilder(ValidatorContext context) {
        this.context = context;
    }

    public AttributeSource getAttributeSource() {
        return this.attributeSource;
    }

    public void setAttributeSource(AttributeSource attributeSource) {
        this.expectedAttributes = null;
        this.attributeSource = attributeSource;
        this.setAttributeSourceDatastoreRefId();
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        if (this.expectedAttributes == null) {
            this.initExpectedAttributes();
        }
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), this.sourceType);
        return new DsSourceTypeValidator(attributeName, afv.getValue(), this.attributeSourceDatastoreRefId, afv.getSource(), this.expectedAttributes, attributePath, DsSourceTypeValidator.DsSourceTypeMsgContext.ATTR_MAPPING, this.context);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        if (this.expectedAttributes == null) {
            this.initExpectedAttributes();
        }
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), this.sourceType);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new DsSourceTypeValidator(null, icEntry.getAttributeName(), this.attributeSourceDatastoreRefId, icEntry.getSource(), this.expectedAttributes, attributePath, DsSourceTypeValidator.DsSourceTypeMsgContext.ISSUANCE_CRITERIA, this.context), icEntry, attributePath);
    }

    private void initExpectedAttributes() {
        this.expectedAttributes = new HashSet<String>();
        if (this.attributeSource != null && this.attributeSource.getDataStoreRef() != null && this.attributeSource.getDataStoreRef().getId() != null) {
            String dsId = this.attributeSource.getDataStoreRef().getId();
            if (this.sourceType == SourceType.CUSTOM_DATA_STORE) {
                CustomDataSource customStore = MgmtFactory.getDataSourceManager().getCustomDataSource(dsId);
                if (customStore != null) {
                    if (customStore.getDriver() == null) {
                        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                        dsMgr.loadCustomDataSourceDriver(customStore);
                    }
                    this.expectedAttributes.addAll(customStore.getDriver().getAvailableFields());
                }
            } else if (this.sourceType == SourceType.LDAP_DATA_STORE && !this.isBypassExternalValidation()) {
                LdapDataSource ldapStore = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
                if (ldapStore != null) {
                    this.expectedAttributes.add("Subject DN");
                    this.expectedAttributes.addAll(ldapStore.getLDAPAttributeNameList());
                }
            } else if (this.sourceType == SourceType.JDBC_DATA_STORE && !this.isBypassExternalValidation()) {
                JdbcAttributeSource jdbcAttrSource = (JdbcAttributeSource)this.attributeSource;
                JdbcDataSource jdbcStore = MgmtFactory.getDataSourceManager().getJdbcDataSource(dsId);
                if (jdbcStore != null) {
                    this.expectedAttributes.addAll(jdbcStore.getUnsortedColumns(jdbcAttrSource.getSchema(), jdbcAttrSource.getTable()));
                }
            }
        }
    }

    private boolean isBypassExternalValidation() {
        return this.getContext() != null && this.getContext().isBypassExternalValidation();
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        if (this.expectedAttributes == null) {
            this.initExpectedAttributes();
        }
        HashSet<String> subsVars = new HashSet<String>();
        boolean sourceIdAvail = this.attributeSource != null ? this.attributeSource.getId() != null : false;
        for (String expectedAttr : this.expectedAttributes) {
            if (sourceIdAvail) {
                subsVars.add("ds." + this.attributeSource.getId() + "." + expectedAttr);
                continue;
            }
            subsVars.add("ds." + expectedAttr);
        }
        return subsVars;
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }

    public void setExpectedAttributes(Set<String> expectedAttributes) {
        this.expectedAttributes = expectedAttributes;
    }

    private void setAttributeSourceDatastoreRefId() {
        if (this.attributeSource != null && this.attributeSource.getDataStoreRef() != null) {
            this.attributeSourceDatastoreRefId = this.attributeSource.getDataStoreRef().getId();
        }
    }
}

