/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class EmailValidator
extends AbstractValidator {
    private String contactEmail;
    private ApiMessageKey key;
    private String fieldPath;

    public EmailValidator(String contactEmail, ApiMessageKey key) {
        this.contactEmail = contactEmail;
        this.key = key;
    }

    public EmailValidator(String contactEmail, ApiMessageKey key, String fieldPath) {
        this(contactEmail, key);
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (!StringUtils.isBlank((String)this.contactEmail) && !this.isContactEmailValid(this.contactEmail)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.key, this.fieldPath));
        }
        return !this.hasErrors();
    }

    private boolean isContactEmailValid(String email) {
        return email.startsWith("mailto:") ? ValidationUtil.isValidUri((String)email) : org.apache.commons.validator.routines.EmailValidator.getInstance().isValid(email);
    }
}

