/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.collections.MapUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;

public class EnableCertRotationValidator
extends AbstractValidator {
    private final ConnectionManager connectionManager;
    private final String certAlias;
    private final String certFieldPath;
    private final boolean isPrintConnectionName;

    public EnableCertRotationValidator(ConnectionManager connectionManager, String certAlias, String certFieldPath, boolean isPrintConnectionName) {
        this.connectionManager = connectionManager;
        this.certAlias = certAlias;
        this.certFieldPath = certFieldPath;
        this.isPrintConnectionName = isPrintConnectionName;
    }

    public boolean validate() {
        if (this.certAlias != null) {
            Collection connections = this.connectionManager.getFilteredConnections();
            StringJoiner connectionsUsingCertAsPrimary = new StringJoiner(", ");
            for (ConnectionBase connection : connections) {
                if (!this.certAlias.equals(connection.getSigningKeyAlias()) || !MapUtils.isNotEmpty((Map)connection.getAltSigningKeyAliasToCertMap())) continue;
                connectionsUsingCertAsPrimary.add("'" + (this.isPrintConnectionName ? connection.getName() : connection.getId()) + "'");
            }
            if (connectionsUsingCertAsPrimary.length() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dsign_used_as_primary_signing_cert_with_secondary_signing_cert_configured, this.certFieldPath, new Object[]{connectionsUsingCertAsPrimary.toString()}));
            }
            StringJoiner connectionsUsingCertAsSecondary = new StringJoiner(", ");
            for (ConnectionBase connection : connections) {
                if (!MapUtils.isNotEmpty((Map)connection.getAltSigningKeyAliasToCertMap())) continue;
                for (String altCertAlias : connection.getAltSigningKeyAliasToCertMap().keySet()) {
                    if (!altCertAlias.equals(this.certAlias)) continue;
                    connectionsUsingCertAsSecondary.add("'" + (this.isPrintConnectionName ? connection.getName() : connection.getId()) + "'");
                }
            }
            if (connectionsUsingCertAsSecondary.length() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dsign_used_as_secondary_signing_cert, this.certFieldPath, new Object[]{connectionsUsingCertAsSecondary.toString()}));
            }
        }
        return !this.hasErrors();
    }
}

