/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Password;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.AbstractValidator;

public class EncryptedFieldValidator
extends AbstractValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String plaintext;
    private String encrypted;
    private ApiMessageEnum decryptionFailedErrorId;
    private String encryptedValueFieldPath;
    private Object[] msgParams;

    public EncryptedFieldValidator(String plaintext, String encrypted, ApiMessageEnum decryptionFailedErrorId, String encryptedValueFieldPath, Object ... msgParams) {
        this.plaintext = plaintext;
        this.encrypted = encrypted;
        this.decryptionFailedErrorId = decryptionFailedErrorId;
        this.encryptedValueFieldPath = encryptedValueFieldPath;
        this.msgParams = msgParams;
    }

    public boolean validate() {
        if (this.encrypted != null && this.plaintext == null) {
            this.plaintext = EncryptedFieldValidator.decryptCiphertext(this.encrypted);
            if (this.plaintext == null) {
                this.appendError(this.errorFactory.create(this.decryptionFailedErrorId, this.encryptedValueFieldPath, this.msgParams));
                return false;
            }
        }
        return true;
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public static String encryptPlaintext(String plaintext) {
        return Password.obfuscateAndEncode((String)plaintext);
    }

    public static String decryptCiphertext(String encrypted) {
        return Password.decodeAndDeobfuscate((String)encrypted);
    }
}

