/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.validator.ConditionalIssuanceCriteriaEntryValidator;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedMetadataSourceTypeValidatorBuilder
extends SourceTypeValidatorBuilder {
    private static final ClientSettingManager OAUTH_CLIENT_SETTINGS_MANAGER = MgmtFactory.getClientSettingManager();
    private SourceType type;

    public ExtendedMetadataSourceTypeValidatorBuilder(SourceType type) {
        this.type = type;
    }

    public ExtendedMetadataSourceTypeValidatorBuilder() {
        this.type = SourceType.EXTENDED_CLIENT_METADATA;
    }

    @Override
    public Validator buildMappingValidator(String attributeName, AttributeFulfillmentValue afv, String attributePath) {
        this.checkAndThrowForIllegalSourceType(afv.getSource().getType(), this.type);
        return new ExtendedMetadataSourceTypeValidator(attributeName, afv.getValue(), this.getExtendedClientMetadata(), attributePath, ExtendedMetadataSourceTypeValidator.ExtendedMetadataSourceTypeMsgContext.ATTR_MAPPING, this.type);
    }

    @Override
    public Validator buildConditionalIssuanceCriteriaValidator(ConditionalIssuanceCriteriaEntry icEntry, String attributePath) {
        this.checkAndThrowForIllegalSourceType(icEntry.getSource().getType(), this.type);
        return new ConditionalIssuanceCriteriaEntryValidator((Validator)new ExtendedMetadataSourceTypeValidator(null, icEntry.getAttributeName(), this.getExtendedClientMetadata(), attributePath, ExtendedMetadataSourceTypeValidator.ExtendedMetadataSourceTypeMsgContext.ISSUANCE_CRITERIA, this.type), icEntry, attributePath);
    }

    public Validator buildMappingValidator(String parameterReferenced) {
        return new ExtendedMetadataSourceTypeValidator("", parameterReferenced, this.getSubstitutionVariables(), "", ExtendedMetadataSourceTypeValidator.ExtendedMetadataSourceTypeMsgContext.ATTR_MAPPING, false, this.type);
    }

    @Override
    public Set<String> getExposedSubstitutionVariables() {
        return this.getExtendedClientMetadata();
    }

    private Set<String> getExtendedClientMetadata() {
        HashSet<String> subVars = new HashSet<String>();
        ClientSetting clientSetting = OAUTH_CLIENT_SETTINGS_MANAGER.getClientSetting();
        String prefix = "extproperties.";
        if (SourceType.EXTENDED_CLIENT_METADATA == this.type) {
            prefix = "extclientmetadata.";
        }
        if (clientSetting != null && clientSetting.getExtendedMetadataParams().size() > 0) {
            for (String metadataKey : clientSetting.getExtendedMetadataParams().keySet()) {
                subVars.add(prefix + metadataKey);
            }
        }
        return subVars;
    }

    @Override
    public boolean acceptsSubstitutionVariables() {
        return false;
    }
}

