/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ExtendedProperty;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.openid.connect.domain.ClientRegistrationCoreParameters;

public class ExtendedPropertiesValidator
extends AbstractValidator {
    private boolean isLegacyPath;
    private Map<String, String> paramDescs = new LinkedHashMap<String, String>();

    public ExtendedPropertiesValidator(Map<String, String> params) {
        this.paramDescs = params;
        this.isLegacyPath = true;
    }

    public ExtendedPropertiesValidator(List<ExtendedProperty> properties, boolean isLegacyPath) {
        this.isLegacyPath = isLegacyPath;
        if (properties != null) {
            int index = 0;
            for (ExtendedProperty extendedProperty : properties) {
                if (this.paramDescs.containsKey(extendedProperty.getName())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.extended_property_duplicate_name, this.getErrorPath(index), new Object[]{extendedProperty.getName()}));
                } else {
                    this.paramDescs.put(extendedProperty.getName(), extendedProperty.getDescription());
                }
                ++index;
            }
        }
    }

    public boolean validate() {
        int index = 0;
        for (Map.Entry<String, String> entry : this.paramDescs.entrySet()) {
            this.validateParamEntry(entry, index++);
        }
        return !this.hasErrors();
    }

    public boolean validateParamEntry(Map.Entry<String, String> entry) {
        return this.validateParamEntry(entry, 0);
    }

    private boolean validateParamEntry(Map.Entry<String, String> entry, int index) {
        String path = this.getErrorPath(index);
        if (entry.getKey() == null || StringUtils.isEmpty((String)entry.getKey())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.extended_property_no_name, path, new Object[]{"Parameter Name"}));
        } else if (ClientRegistrationCoreParameters.getCoreMetadataParamNames().contains(entry.getKey())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.extended_property_invalid_name, path, new Object[]{entry.getKey()}));
        }
        return !this.hasErrors();
    }

    private String getErrorPath(int index) {
        if (this.isLegacyPath) {
            return ClientSettingsPaths.getMetadataParameter(index);
        }
        return "items[" + index + "].name";
    }
}

