/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertyValueValidator
extends AbstractValidator {
    private Map<String, ParamValues> paramValues;
    private boolean isConnectionApi = false;
    private final ClientSettingManager clientSettingManager = MgmtFactory.getClientSettingManager();

    public ExtendedPropertyValueValidator(Map<String, ParamValues> params, boolean isConnectionApi) {
        this.paramValues = params;
        this.isConnectionApi = isConnectionApi;
    }

    public ExtendedPropertyValueValidator(Map<String, ParamValues> params) {
        this.paramValues = params;
    }

    public boolean validate() {
        Map params = this.clientSettingManager.getClientSetting().getExtendedMetadataParams();
        block0: for (Map.Entry<String, ParamValues> entry : this.paramValues.entrySet()) {
            String name = entry.getKey();
            HashSet<String> uniqueValue = new HashSet<String>();
            if (params.containsKey(name)) {
                List values;
                if (entry.getValue() == null || (values = entry.getValue().getElements()) == null) continue;
                if (!((ClientParam)params.get(name)).isMultiValued() && values.size() > 1) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ext_property_multivalue_disabled, this.getBasePath(), new Object[]{name}));
                    continue;
                }
                for (String value : values) {
                    if (uniqueValue.contains(value)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ext_property_value_duplicate_entry, this.getBasePath(), new Object[]{name, value}));
                        continue block0;
                    }
                    this.validateParamEntry(name, value);
                    uniqueValue.add(value);
                }
                continue;
            }
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ext_property_name_invalid, this.getBasePath(), new Object[]{name}));
        }
        return !this.hasErrors();
    }

    public boolean validateParamEntry(String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ext_property_value_required, this.getBasePath(), new Object[]{name}));
        }
        return !this.hasErrors();
    }

    private String getBasePath() {
        if (this.isConnectionApi) {
            return ConnectionPaths.getExtendedProperties();
        }
        return ClientPaths.getExtendedParameters();
    }
}

