/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.IssuanceCriteria;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import java.util.Map;

public class FailSafeAttributeValidator
extends AbstractValidator {
    private final boolean abortSsoTransactionAsFailSafe;
    private final List<AttributeSource> attributeSourcesList;
    private final IssuanceCriteria issuanceCriteria;
    private final Map<String, AttributeFulfillmentValue> attributeContractFulfillment;
    private final String fieldPath;

    public FailSafeAttributeValidator(boolean abortSsoTransactionAsFailSafe, List<AttributeSource> attributeSourcesList, IssuanceCriteria issuanceCriteria, Map<String, AttributeFulfillmentValue> attributeContractFulfillment, String fieldPath) {
        this.abortSsoTransactionAsFailSafe = abortSsoTransactionAsFailSafe;
        this.attributeSourcesList = attributeSourcesList;
        this.issuanceCriteria = issuanceCriteria;
        this.attributeContractFulfillment = attributeContractFulfillment;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (this.abortSsoTransactionAsFailSafe) {
            if (this.attributeSourcesList == null || this.attributeSourcesList.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_abort_sso_must_have_attribute_source, this.fieldPath));
            }
            if (this.issuanceCriteria != null && this.issuanceCriteria.hasIssuanceCriteria()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_abort_sso_and_issuance_criteria, this.fieldPath));
            }
            if (this.attributeContractFulfillment != null && !this.attributeContractFulfillment.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_abort_sso_and_attribute_contract_fulfillment, this.fieldPath));
            }
        }
        return !this.hasErrors();
    }
}

