/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.FragmentPolicyAction;
import com.pingidentity.admin.api.model.fieldpaths.AuthenticationPolicyActionPaths;
import com.pingidentity.admin.api.validator.AbstractAuthnSourceActionValidator;
import com.pingidentity.admin.api.validator.AuthnPolicyFragmentMappingValidator;
import com.pingidentity.admin.api.validator.PolicyFragmentValidator;
import com.pingidentity.admin.api.validator.structures.ActionValidatorInfo;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class FragmentActionValidator
extends AbstractAuthnSourceActionValidator {
    private final PolicyFragmentManager pfMgr = MgmtFactory.getPolicyFragmentManager();
    private final ValidatorContext context;

    public FragmentActionValidator(ActionValidatorInfo info, ValidatorContext context) {
        super(info, context);
        this.context = context;
        if (!context.isBulkConfigRequest() && info.isFragmentPolicy()) {
            this.addValidator((Validator)new PolicyFragmentValidator(((FragmentPolicyAction)this.validatorInfo.getAction()).getFragment().getId(), context));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.validatorInfo.getChildren() != null) {
            this.checkFailSuccessContextsPresent();
        }
        if (this.hasErrors() || !this.validateFragmentExists()) {
            return false;
        }
        this.validateFragmentMapping(((FragmentPolicyAction)this.validatorInfo.getAction()).getFragmentMapping());
        this.validateAttributeRules(((FragmentPolicyAction)this.validatorInfo.getAction()).getAttributeRules());
        return !this.hasErrors();
    }

    void validateFragmentMapping(AttributeMapping fragmentMapping) {
        String fragmentId = ((FragmentPolicyAction)this.validatorInfo.getAction()).getFragment().getId();
        PolicyFragment fragment = this.pfMgr.getFragment(fragmentId);
        C2cContract apfc = fragment.getInputContract();
        if (apfc != null) {
            AuthnPolicyFragmentMappingValidator attributeMappingValidator = new AuthnPolicyFragmentMappingValidator(fragmentMapping, apfc, this.validatorInfo.getUpstreamSources(), this.validatorInfo.getRootFieldPath(), this.validatorInfo.getTrackedParams(), this.context, this.validatorInfo.getFragmentInfo());
            attributeMappingValidator.validate();
            this.appendErrors(attributeMappingValidator.getErrors());
        } else if (fragmentMapping != null && fragmentMapping.hasAttributeMapping()) {
            this.appendError(this.errorFactory.create(ApiMessageKey.authn_policy_fragment_mapping_not_allowed, this.makeFieldPath(AuthenticationPolicyActionPaths.getFragmentMapping())));
        }
    }

    private boolean validateFragmentExists() {
        String fragmentId = ((FragmentPolicyAction)this.validatorInfo.getAction()).getFragment().getId();
        PolicyFragment fragment = this.pfMgr.getFragment(fragmentId);
        if (fragment == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.fragment_does_not_exist, this.makeFieldPath(AuthenticationPolicyActionPaths.getType()), new Object[]{fragmentId}));
            return false;
        }
        return true;
    }

    @Override
    protected boolean isActionAllowed() {
        return true;
    }

    @Override
    protected boolean needsChildren() {
        return true;
    }
}

